/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.stream;

import com.didichuxing.doraemonkit.kit.network.core.ResponseHandler;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamProxy
extends FilterInputStream {
    public static final String TAG = "ResponseHandlingInputStream";
    private static final int BUFFER_SIZE = 1024;
    private final ByteArrayOutputStream mOutputStream = new ByteArrayOutputStream();
    private final ResponseHandler mResponseHandler;
    private boolean mClosed;
    private byte[] mSkipBuffer;

    public InputStreamProxy(InputStream inputStream, ResponseHandler responseHandler) {
        super(inputStream);
        this.mResponseHandler = responseHandler;
        this.mClosed = false;
    }

    private synchronized int checkEOF(int n) {
        if (n == -1) {
            if (this.mResponseHandler != null) {
                this.mResponseHandler.onEOF(this.mOutputStream);
            }
            this.closeOutputStreamQuietly();
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        try {
            int result2 = this.checkEOF(this.in.read());
            if (result2 != -1) {
                this.writeToOutputStream(result2);
            }
            return result2;
        }
        catch (IOException ex) {
            throw this.handleIOException(ex);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int result2 = this.checkEOF(this.in.read(b, off, len));
            if (result2 != -1) {
                this.writeToOutputStream(b, off, result2);
            }
            return result2;
        }
        catch (IOException ex) {
            throw this.handleIOException(ex);
        }
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long bytesDiff;
        int bytesToRead;
        long total;
        int result2;
        byte[] buffer = this.getSkipBufferLocked();
        for (total = 0L; total < n && (result2 = this.read(buffer, 0, bytesToRead = (int)Math.min((long)buffer.length, bytesDiff = n - total))) != -1; total += (long)result2) {
        }
        return total;
    }

    private byte[] getSkipBufferLocked() {
        if (this.mSkipBuffer == null) {
            this.mSkipBuffer = new byte[1024];
        }
        return this.mSkipBuffer;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("Mark not supported");
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closeOutputStreamQuietly();
    }

    private synchronized void closeOutputStreamQuietly() {
        if (!this.mClosed) {
            try {
                this.mOutputStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.mClosed = true;
            }
        }
    }

    private IOException handleIOException(IOException ex) {
        if (this.mResponseHandler != null) {
            this.mResponseHandler.onError(ex);
        }
        return ex;
    }

    private synchronized void writeToOutputStream(int oneByte) {
        if (this.mClosed) {
            return;
        }
        this.mOutputStream.write(oneByte);
    }

    private synchronized void writeToOutputStream(byte[] b, int offset, int count) {
        if (this.mClosed) {
            return;
        }
        this.mOutputStream.write(b, offset, count);
    }
}

