/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.common;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.kit.network.common.CommonHeaders;
import com.didichuxing.doraemonkit.kit.network.core.NetworkInterpreter;
import java.util.List;

public class CommonInspectorRequest
implements NetworkInterpreter.InspectorRequest {
    private final int mRequestId;
    private final String url;
    private final String method;
    private final String body;
    private final CommonHeaders headers;

    public CommonInspectorRequest(int requestId, @NonNull String url, @NonNull String method, @Nullable String body, @Nullable CommonHeaders headers) {
        this.mRequestId = requestId;
        this.url = url;
        this.method = method;
        this.body = body;
        this.headers = headers;
    }

    @Override
    public int id() {
        return this.mRequestId;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public byte[] body() {
        if (TextUtils.isEmpty((CharSequence)this.body)) {
            return null;
        }
        return this.body.getBytes();
    }

    @Override
    public int headerCount() {
        if (this.headers != null) {
            return this.headers.size();
        }
        return 0;
    }

    @Override
    public String headerName(int index) {
        if (this.headers != null) {
            return this.headers.name(index);
        }
        return null;
    }

    @Override
    public String headerValue(int index) {
        if (this.headers != null) {
            return this.headers.value(index);
        }
        return null;
    }

    @Override
    public String firstHeaderValue(String name) {
        List<String> values;
        if (this.headers != null && (values = this.headers.values(name)) != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }
}

