/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.loginfo;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.loginfo.LogLine;
import com.didichuxing.doraemonkit.kit.loginfo.util.SearchCriteria;
import com.didichuxing.doraemonkit.kit.loginfo.util.TagColorUtil;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsRecyclerAdapter;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsViewBinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LogItemAdapter
extends AbsRecyclerAdapter<AbsViewBinder<LogLine>, LogLine>
implements Filterable {
    private ArrayList<LogLine> mOriginalValues = new ArrayList();
    private ArrayFilter mFilter = new ArrayFilter();
    private int logLevelLimit = 2;
    private ClipboardManager mClipboard;

    public LogItemAdapter(Context context) {
        super(context);
        this.mClipboard = (ClipboardManager)context.getSystemService("clipboard");
    }

    public void clearLog() {
        if (this.mOriginalValues != null && this.mOriginalValues.size() > 0) {
            this.mOriginalValues.clear();
        }
        this.clear();
        this.notifyDataSetChanged();
    }

    @Override
    protected AbsViewBinder<LogLine> createViewHolder(View view, int viewType) {
        return new LogInfoViewHolder(view);
    }

    @Override
    protected View createView(LayoutInflater inflater, ViewGroup parent, int viewType) {
        return inflater.inflate(R.layout.dk_item_log, parent, false);
    }

    public Filter getFilter() {
        return this.mFilter;
    }

    public int getLogLevelLimit() {
        return this.logLevelLimit;
    }

    public void setLogLevelLimit(int logLevelLimit) {
        this.logLevelLimit = logLevelLimit;
    }

    public List<LogLine> getTrueValues() {
        return this.mOriginalValues != null ? this.mOriginalValues : this.mList;
    }

    public void removeFirst(int n) {
        if (this.mOriginalValues != null) {
            List<LogLine> subList = this.mOriginalValues.subList(n, this.mOriginalValues.size());
            for (int i = 0; i < n; ++i) {
                this.mList.remove(this.mOriginalValues.get(i));
            }
            this.mOriginalValues = new ArrayList<LogLine>(subList);
        }
        this.notifyDataSetChanged();
    }

    public void addWithFilter(LogLine logObj, CharSequence text, boolean notify) {
        if (this.mOriginalValues != null) {
            List<LogLine> inputList = Collections.singletonList(logObj);
            ArrayList<LogLine> filteredObjects = this.mFilter.performFilteringOnList(inputList, text);
            this.mOriginalValues.add(logObj);
            this.mList.addAll(filteredObjects);
            if (notify) {
                this.notifyItemRangeInserted(this.mList.size() - filteredObjects.size(), filteredObjects.size());
            }
        } else {
            this.mList.add(logObj);
            if (notify) {
                this.notifyItemInserted(this.mList.size());
            }
        }
    }

    private class ArrayFilter
    extends Filter {
        private ArrayFilter() {
        }

        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            ArrayList<LogLine> allValues;
            Filter.FilterResults results = new Filter.FilterResults();
            results.values = allValues = this.performFilteringOnList(LogItemAdapter.this.mOriginalValues, prefix);
            results.count = allValues.size();
            return results;
        }

        public ArrayList<LogLine> performFilteringOnList(List<LogLine> inputList, CharSequence query) {
            SearchCriteria searchCriteria = new SearchCriteria(query);
            ArrayList<LogLine> allValues = new ArrayList<LogLine>();
            ArrayList<LogLine> logLines = new ArrayList<LogLine>(inputList);
            for (LogLine logLine : logLines) {
                if (logLine == null || logLine.getLogLevel() < LogItemAdapter.this.logLevelLimit) continue;
                allValues.add(logLine);
            }
            ArrayList<LogLine> finalValues = allValues;
            if (!searchCriteria.isEmpty()) {
                ArrayList<LogLine> values = allValues;
                int count = values.size();
                ArrayList<LogLine> newValues = new ArrayList<LogLine>(count);
                for (int i = 0; i < count; ++i) {
                    LogLine value = values.get(i);
                    if (!searchCriteria.matches(value)) continue;
                    newValues.add(value);
                }
                finalValues = newValues;
            }
            return finalValues;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            LogItemAdapter.this.mList = (List)results.values;
            if (results.count > 0) {
                LogItemAdapter.this.notifyDataSetChanged();
            } else {
                LogItemAdapter.this.notifyDataSetChanged();
            }
        }
    }

    public class LogInfoViewHolder
    extends AbsViewBinder<LogLine> {
        private TextView mLogText;
        private TextView mPid;
        private TextView mTime;
        private TextView mTag;
        private TextView mLevel;

        public LogInfoViewHolder(View view) {
            super(view);
        }

        @Override
        protected void getViews() {
            this.mLogText = (TextView)this.getView(R.id.log_output_text);
            this.mLevel = (TextView)this.getView(R.id.log_level_text);
            this.mPid = (TextView)this.getView(R.id.pid_text);
            this.mTime = (TextView)this.getView(R.id.timestamp_text);
            this.mTag = (TextView)this.getView(R.id.tag_text);
        }

        @Override
        protected void onViewClick(View view, final LogLine data) {
            super.onViewClick(view, data);
            data.setExpanded(!data.isExpanded());
            if (data.isExpanded() && data.getProcessId() != -1) {
                this.mLogText.setSingleLine(false);
                this.mTime.setVisibility(0);
                this.mPid.setVisibility(0);
                view.setBackgroundColor(-16777216);
                this.mLogText.setTextColor(TagColorUtil.getTextColor(this.getContext(), data.getLogLevel(), true));
                this.mTag.setTextColor(TagColorUtil.getTextColor(this.getContext(), data.getLogLevel(), true));
            } else {
                this.mLogText.setSingleLine(true);
                this.mTime.setVisibility(8);
                this.mPid.setVisibility(8);
                view.setBackgroundColor(-1);
                this.mLogText.setTextColor(TagColorUtil.getTextColor(this.getContext(), data.getLogLevel(), false));
                this.mTag.setTextColor(TagColorUtil.getTextColor(this.getContext(), data.getLogLevel(), false));
            }
            this.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    ClipData clipData = ClipData.newPlainText((CharSequence)"Label", (CharSequence)data.getOriginalLine());
                    LogItemAdapter.this.mClipboard.setPrimaryClip(clipData);
                    ToastUtils.showShort((CharSequence)"copy success");
                    return true;
                }
            });
        }

        @Override
        public void bind(LogLine item) {
            this.mLevel.setText((CharSequence)item.getLogLevelText());
            this.mLevel.setTextColor(TagColorUtil.getLevelColor(this.getContext(), item.getLogLevel()));
            this.mLevel.setBackgroundColor(TagColorUtil.getLevelBgColor(this.getContext(), item.getLogLevel()));
            this.mPid.setText((CharSequence)String.valueOf(item.getProcessId()));
            this.mTime.setText((CharSequence)item.getTimestamp());
            this.mLogText.setText((CharSequence)item.getLogOutput());
            this.mTag.setText((CharSequence)item.getTag());
            if (item.isExpanded() && item.getProcessId() != -1) {
                this.mLogText.setSingleLine(false);
                this.mTime.setVisibility(0);
                this.mPid.setVisibility(0);
                this.mLogText.setTextColor(TagColorUtil.getTextColor(this.getContext(), item.getLogLevel(), true));
                this.mTag.setTextColor(TagColorUtil.getTextColor(this.getContext(), item.getLogLevel(), true));
                this.itemView.setBackgroundColor(-16777216);
            } else {
                this.mLogText.setSingleLine(true);
                this.mTime.setVisibility(8);
                this.mPid.setVisibility(8);
                this.itemView.setBackgroundColor(-1);
                this.mLogText.setTextColor(TagColorUtil.getTextColor(this.getContext(), item.getLogLevel(), false));
                this.mTag.setTextColor(TagColorUtil.getTextColor(this.getContext(), item.getLogLevel(), false));
            }
        }
    }
}

