/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.largepicture;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.PerformanceSpInfoConfig;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.core.SettingItem;
import com.didichuxing.doraemonkit.kit.largepicture.LargeImageListFragment;
import com.didichuxing.doraemonkit.kit.largepicture.LargePictureItemAdapter;
import com.didichuxing.doraemonkit.kit.largepicture.LargePictureManager;
import com.didichuxing.doraemonkit.kit.network.NetworkManager;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;
import java.text.DecimalFormat;

public class LargePictureFragment
extends BaseFragment {
    private LargePictureItemAdapter mSettingItemAdapter;
    private RecyclerView mSettingList;
    private DecimalFormat mDecimalFormat = new DecimalFormat("0.00");

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_performance_large_picture_setting;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    private void initView() {
        HomeTitleBar titleBar = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        titleBar.setTitle(R.string.dk_category_large_image);
        EditText fileEditText = (EditText)this.findViewById(R.id.ed_file_threshold);
        fileEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                try {
                    if (TextUtils.isEmpty((CharSequence)s)) {
                        ToastUtils.showShort((CharSequence)"value can not null");
                        return;
                    }
                    if (Float.parseFloat(s.toString()) < 0.0f) {
                        ToastUtils.showShort((CharSequence)"value can not  < 0");
                        return;
                    }
                    float value = Float.parseFloat(s.toString());
                    float formateValue = Float.parseFloat(LargePictureFragment.this.mDecimalFormat.format(value));
                    PerformanceSpInfoConfig.setLargeImgFileThreshold(formateValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        EditText memoryEditText = (EditText)this.findViewById(R.id.ed_memory_threshold);
        memoryEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                try {
                    if (TextUtils.isEmpty((CharSequence)s)) {
                        ToastUtils.showShort((CharSequence)"value can not null");
                        return;
                    }
                    if (Float.parseFloat(s.toString()) < 0.0f) {
                        ToastUtils.showShort((CharSequence)"value can not  < 0");
                        return;
                    }
                    float value = Float.parseFloat(s.toString());
                    float formateValue = Float.parseFloat(LargePictureFragment.this.mDecimalFormat.format(value));
                    PerformanceSpInfoConfig.setLargeImgMemoryThreshold(formateValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        double fileThreshold = PerformanceSpInfoConfig.getLargeImgFileThreshold(LargePictureManager.FILE_DEFAULT_THRESHOLD);
        fileEditText.setText((CharSequence)this.mDecimalFormat.format(fileThreshold));
        double memoryThreshold = PerformanceSpInfoConfig.getLargeImgMemoryThreshold(LargePictureManager.MEMORY_DEFAULT_THRESHOLD);
        memoryEditText.setText((CharSequence)this.mDecimalFormat.format(memoryThreshold));
        titleBar.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                LargePictureFragment.this.getActivity().finish();
            }
        });
        this.mSettingList = (RecyclerView)this.findViewById(R.id.setting_list);
        this.mSettingList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mSettingItemAdapter = new LargePictureItemAdapter(this.getContext());
        this.mSettingItemAdapter.append(new SettingItem(R.string.dk_large_picture_switch, PerformanceSpInfoConfig.isLargeImgOpen()));
        this.mSettingItemAdapter.append(new SettingItem(R.string.dk_large_picture_look, R.mipmap.dk_more_icon));
        this.mSettingItemAdapter.setOnSettingItemSwitchListener(new LargePictureItemAdapter.OnSettingItemSwitchListener(){

            @Override
            public void onSettingItemSwitch(View view, SettingItem data, boolean on) {
                if (data.desc == R.string.dk_large_picture_switch) {
                    PerformanceSpInfoConfig.setLargeImgOpen(on);
                    if (on) {
                        if (!NetworkManager.isActive()) {
                            NetworkManager.get().startMonitor();
                        }
                    } else {
                        NetworkManager.get().stopMonitor();
                        LargePictureManager.LARGE_IMAGE_INFO_MAP.clear();
                    }
                }
            }
        });
        this.mSettingItemAdapter.setOnSettingItemClickListener(new LargePictureItemAdapter.OnSettingItemClickListener(){

            @Override
            public void onSettingItemClick(View view, SettingItem data) {
                if (data.desc == R.string.dk_large_picture_look) {
                    LargePictureFragment.this.showContent(LargeImageListFragment.class);
                }
            }
        });
        this.mSettingList.setAdapter((RecyclerView.Adapter)this.mSettingItemAdapter);
    }

    public void onDestroyView() {
        super.onDestroyView();
    }
}

