/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.gpsmock;

import android.content.Context;
import android.os.IBinder;
import com.didichuxing.doraemonkit.kit.gpsmock.BaseServiceHooker;
import com.didichuxing.doraemonkit.kit.gpsmock.BinderHookHandler;
import com.didichuxing.doraemonkit.kit.gpsmock.LocationHooker;
import com.didichuxing.doraemonkit.util.ReflectUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/didichuxing/doraemonkit/kit/gpsmock/ServiceHookManager;", "", "()V", "TAG", "", "isHookSuccess", "", "()Z", "setHookSuccess", "(Z)V", "mHookers", "", "Lcom/didichuxing/doraemonkit/kit/gpsmock/BaseServiceHooker;", "init", "", "install", "context", "Landroid/content/Context;", "dokit_release"})
public final class ServiceHookManager {
    private static boolean isHookSuccess;
    private static final List<BaseServiceHooker> mHookers;
    @NotNull
    public static final String TAG = "ServiceHookManager";
    @NotNull
    public static final ServiceHookManager INSTANCE;

    public final boolean isHookSuccess() {
        return isHookSuccess;
    }

    public final void setHookSuccess(boolean bl) {
        isHookSuccess = bl;
    }

    private final void init() {
        mHookers.add(new LocationHooker());
    }

    public final void install(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ReflectUtils serviceManager = ReflectUtils.reflect((String)"android.os.ServiceManager");
            for (BaseServiceHooker hooker : mHookers) {
                Map cache;
                IBinder binderProxy;
                if ((IBinder)serviceManager.method("getService", new Object[]{hooker.serviceName()}).get() == null) {
                    continue;
                }
                hooker.asInterface(binderProxy);
                ClassLoader classLoader = binderProxy.getClass().getClassLoader();
                Class[] iBinders = new Class[]{IBinder.class};
                BinderHookHandler handler = new BinderHookHandler(binderProxy, hooker);
                Object object = Proxy.newProxyInstance(classLoader, iBinders, (InvocationHandler)handler);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.os.IBinder");
                }
                IBinder proxy = (IBinder)object;
                hooker.replaceBinderProxy(context, proxy);
                Map map = cache = (Map)serviceManager.field("sCache").get();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"cache");
                map.put(hooker.serviceName(), proxy);
            }
            isHookSuccess = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ServiceHookManager() {
    }

    static {
        ServiceHookManager serviceHookManager;
        INSTANCE = serviceHookManager = new ServiceHookManager();
        mHookers = new ArrayList();
        serviceHookManager.init();
    }
}

