/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.gpsmock;

public class CordTransformUtil {
    static double x_PI = 52.35987755982988;
    static double PI = Math.PI;
    static double a = 6378245.0;
    static double ee = 0.006693421622965943;

    public static Point gcj02tobd09(double lat, double lng) {
        double z = Math.sqrt(lng * lng + lat * lat) + 2.0E-5 * Math.sin(lat * x_PI);
        double theta = Math.atan2(lat, lng) + 3.0E-6 * Math.cos(lng * x_PI);
        double bd_lng = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        return new Point(bd_lat, bd_lng);
    }

    public static Point wgs84togcj02(double lat, double lng) {
        double dlat = CordTransformUtil.transformlat(lat - 35.0, lng - 105.0);
        double dlng = CordTransformUtil.transformlng(lat - 35.0, lng - 105.0);
        double radlat = lat / 180.0 * PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - ee * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (a * (1.0 - ee) / (magic * sqrtmagic) * PI);
        dlng = dlng * 180.0 / (a / sqrtmagic * Math.cos(radlat) * PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        return new Point(mglat, mglng);
    }

    public static Point gcj02towgs84(double lat, double lng) {
        double dlat = CordTransformUtil.transformlat(lat - 35.0, lng - 105.0);
        double dlng = CordTransformUtil.transformlng(lat - 35.0, lng - 105.0);
        double radlat = lat / 180.0 * PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - ee * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (a * (1.0 - ee) / (magic * sqrtmagic) * PI);
        dlng = dlng * 180.0 / (a / sqrtmagic * Math.cos(radlat) * PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        return new Point(mglat, mglng);
    }

    public static Point wgs84tobd09(double lat, double lng) {
        double dlat = CordTransformUtil.transformlat(lat - 35.0, lng - 105.0);
        double dlng = CordTransformUtil.transformlng(lat - 35.0, lng - 105.0);
        double radlat = lat / 180.0 * PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - ee * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (a * (1.0 - ee) / (magic * sqrtmagic) * PI);
        dlng = dlng * 180.0 / (a / sqrtmagic * Math.cos(radlat) * PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        double z = Math.sqrt(mglng * mglng + mglat * mglat) + 2.0E-5 * Math.sin(mglat * x_PI);
        double theta = Math.atan2(mglat, mglng) + 3.0E-6 * Math.cos(mglng * x_PI);
        double bd_lng = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        return new Point(bd_lat, bd_lng);
    }

    public Point bd09togcj02(double bd_lat, double bd_lon) {
        double x = bd_lon - 0.0065;
        double y = bd_lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * x_PI);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * x_PI);
        double gg_lng = z * Math.cos(theta);
        double gg_lat = z * Math.sin(theta);
        return new Point(gg_lat, gg_lng);
    }

    private static double transformlat(double lat, double lng) {
        double ret = -100.0 + 2.0 * lng + 3.0 * lat + 0.2 * lat * lat + 0.1 * lng * lat + 0.2 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * PI) + 20.0 * Math.sin(2.0 * lng * PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * PI) + 40.0 * Math.sin(lat / 3.0 * PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(lat / 12.0 * PI) + 320.0 * Math.sin(lat * PI / 30.0)) * 2.0 / 3.0;
    }

    private static double transformlng(double lat, double lng) {
        double ret = 300.0 + lng + 2.0 * lat + 0.1 * lng * lng + 0.1 * lng * lat + 0.1 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * PI) + 20.0 * Math.sin(2.0 * lng * PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lng * PI) + 40.0 * Math.sin(lng / 3.0 * PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(lng / 12.0 * PI) + 300.0 * Math.sin(lng / 30.0 * PI)) * 2.0 / 3.0;
    }

    public static void main(String[] args) {
        String lnglat = CordTransformUtil.wgs84togcj02(31.841652709281103, 117.20296517261839).toString();
        double lng = Double.parseDouble(lnglat.split(",")[0]);
        double lat = Double.parseDouble(lnglat.split(",")[1]);
        System.out.println("\u7b2c\u4e00\u6b21\u8f6c\u6362\u7684\u7ed3\u679c:" + lng + "," + lat);
        System.out.println("\u7b2c\u4e8c\u6b21\u8f6c\u6362\u7684\u7ed3\u679c:" + CordTransformUtil.gcj02tobd09(lat, lng));
        System.out.println("\u8c37\u6b4c\u8f6c\u6362\u4e3a\u767e\u5ea6\u4e00\u6b21\u8f6c\u6362\u7684\u7ed3\u679c:" + CordTransformUtil.wgs84tobd09(31.841652709281103, 117.20296517261839));
    }

    public static class Point {
        double mLat;
        double mLng;

        public String toString() {
            return "\u7eac\u5ea6: " + this.mLat + ", \u7ecf\u5ea6: " + this.mLng;
        }

        public Point(double lat, double lng) {
            this.mLat = lat;
            this.mLng = lng;
        }

        public double getLatitude() {
            return this.mLat;
        }

        public Point setLatitude(double lat) {
            this.mLat = lat;
            return this;
        }

        public double getLongitude() {
            return this.mLng;
        }

        public Point setLongitude(double lng) {
            this.mLng = lng;
            return this;
        }
    }
}

