/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.fileexplorer;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.fileexplorer.FileInfo;
import com.didichuxing.doraemonkit.util.DoKitFileUtil;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsRecyclerAdapter;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsViewBinder;

public class FileInfoAdapter
extends AbsRecyclerAdapter<AbsViewBinder<FileInfo>, FileInfo> {
    private OnViewClickListener mOnViewClickListener;
    private OnViewLongClickListener mOnViewLongClickListener;

    public FileInfoAdapter(Context context) {
        super(context);
    }

    @Override
    protected AbsViewBinder<FileInfo> createViewHolder(View view, int viewType) {
        return new FileInfoViewHolder(view);
    }

    @Override
    protected View createView(LayoutInflater inflater, ViewGroup parent, int viewType) {
        return inflater.inflate(R.layout.dk_item_file_info, parent, false);
    }

    public void setOnViewClickListener(OnViewClickListener onViewClickListener) {
        this.mOnViewClickListener = onViewClickListener;
    }

    public void setOnViewLongClickListener(OnViewLongClickListener onViewLongClickListener) {
        this.mOnViewLongClickListener = onViewLongClickListener;
    }

    public static interface OnViewLongClickListener {
        public boolean onViewLongClick(View var1, FileInfo var2);
    }

    public static interface OnViewClickListener {
        public void onViewClick(View var1, FileInfo var2);
    }

    public class FileInfoViewHolder
    extends AbsViewBinder<FileInfo> {
        private TextView mName;
        private ImageView mIcon;
        private ImageView mMoreBtn;

        public FileInfoViewHolder(View view) {
            super(view);
        }

        @Override
        protected void getViews() {
            this.mName = (TextView)this.getView(R.id.name);
            this.mIcon = (ImageView)this.getView(R.id.icon);
            this.mMoreBtn = (ImageView)this.getView(R.id.more);
        }

        @Override
        public void bind(final FileInfo fileInfo) {
            this.getView().setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return FileInfoAdapter.this.mOnViewLongClickListener != null && FileInfoAdapter.this.mOnViewLongClickListener.onViewLongClick(v, fileInfo);
                }
            });
            this.mName.setText((CharSequence)fileInfo.file.getName());
            if (fileInfo.file.isDirectory()) {
                this.mIcon.setImageResource(R.mipmap.dk_dir_icon);
                this.mMoreBtn.setVisibility(0);
            } else {
                if (DoKitFileUtil.getSuffix(fileInfo.file).equals("jpg")) {
                    this.mIcon.setImageResource(R.mipmap.dk_jpg_icon);
                } else if (DoKitFileUtil.getSuffix(fileInfo.file).equals("txt")) {
                    this.mIcon.setImageResource(R.mipmap.dk_txt_icon);
                } else if (DoKitFileUtil.getSuffix(fileInfo.file).equals("db")) {
                    this.mIcon.setImageResource(R.mipmap.dk_file_db);
                } else {
                    this.mIcon.setImageResource(R.mipmap.dk_file_icon);
                }
                this.mMoreBtn.setVisibility(8);
            }
        }

        @Override
        protected void onViewClick(View view, FileInfo data) {
            super.onViewClick(view, data);
            if (FileInfoAdapter.this.mOnViewClickListener != null) {
                FileInfoAdapter.this.mOnViewClickListener.onViewClick(view, data);
            }
        }
    }
}

