/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.fileexplorer;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.fileexplorer.DBListAdapter;
import com.didichuxing.doraemonkit.util.DatabaseUtil;
import com.didichuxing.doraemonkit.widget.tableview.TableConfig;
import com.didichuxing.doraemonkit.widget.tableview.bean.ArrayTableData;
import com.didichuxing.doraemonkit.widget.tableview.component.SmartTable;
import com.didichuxing.doraemonkit.widget.tableview.format.FastTextDrawFormat;
import com.didichuxing.doraemonkit.widget.tableview.style.FontStyle;
import com.didichuxing.doraemonkit.widget.titlebar.TitleBar;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DatabaseDetailFragment
extends BaseFragment {
    private SmartTable table;
    private ListView tableListView;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_db_detail;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Bundle data = this.getArguments();
        SQLiteDatabase sqLiteDatabase = null;
        List<Object> tableNames = new ArrayList();
        if (data != null) {
            File mFile = (File)data.getSerializable("file_key");
            String path = mFile.getPath();
            sqLiteDatabase = SQLiteDatabase.openOrCreateDatabase((String)path, null);
            tableNames = DatabaseUtil.queryTableName(sqLiteDatabase);
        }
        this.table = (SmartTable)this.findViewById(R.id.table);
        FontStyle fontStyle = new FontStyle(this.getContext(), 15, ContextCompat.getColor((Context)this.getContext(), (int)R.color.dk_color_000000));
        TableConfig.getInstance().setVerticalPadding(10).setHorizontalPadding(10);
        TableConfig.getInstance().columnTitleStyle = fontStyle;
        this.table.setZoom(true, 2.0f, 0.4f);
        this.tableListView = (ListView)this.findViewById(R.id.lv_table_name);
        this.tableListView.setAdapter((ListAdapter)new DBListAdapter(this.getContext(), tableNames));
        final List<Object> finalStrings = tableNames;
        final SQLiteDatabase finalSqLiteDatabase = sqLiteDatabase;
        TitleBar titleBar = (TitleBar)((Object)this.findViewById(R.id.title_bar));
        titleBar.setOnTitleBarClickListener(new TitleBar.OnTitleBarClickListener(){

            @Override
            public void onLeftClick() {
                DatabaseDetailFragment.this.onBackPressed();
            }

            @Override
            public void onRightClick() {
            }
        });
        this.tableListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                String selectTableName = (String)finalStrings.get(position);
                String[][] data = DatabaseUtil.queryAll(finalSqLiteDatabase, (String)finalStrings.get(position));
                String[] titleName = DatabaseUtil.queryTableColumnName(finalSqLiteDatabase, selectTableName);
                if (DatabaseDetailFragment.this.table.getTableData() != null) {
                    DatabaseDetailFragment.this.table.getTableData().clear();
                }
                DatabaseDetailFragment.this.table.setTableData(ArrayTableData.create(selectTableName, titleName, data, new FastTextDrawFormat()));
                DatabaseDetailFragment.this.table.getMatrixHelper().reset();
                DatabaseDetailFragment.this.tableListView.setVisibility(8);
                DatabaseDetailFragment.this.table.setVisibility(0);
            }
        });
    }

    @Override
    public boolean onBackPressed() {
        if (this.table.getVisibility() == 0) {
            this.table.setVisibility(8);
            this.tableListView.setVisibility(0);
        } else {
            this.finish();
        }
        return true;
    }
}

