/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.core;

import android.view.MotionEvent;
import android.view.View;
import com.didichuxing.doraemonkit.util.UIUtils;

public class TouchProxy {
    private static final int MIN_DISTANCE_MOVE = 4;
    private static final int MIN_TAP_TIME = 1000;
    private OnTouchEventListener mEventListener;
    private int mLastX;
    private int mLastY;
    private int mStartX;
    private int mStartY;
    private TouchState mState = TouchState.STATE_STOP;

    public TouchProxy(OnTouchEventListener eventListener) {
        this.mEventListener = eventListener;
    }

    public void setEventListener(OnTouchEventListener eventListener) {
        this.mEventListener = eventListener;
    }

    public boolean onTouchEvent(View v, MotionEvent event) {
        int distance = UIUtils.dp2px(1.0f) * 4;
        int x = (int)event.getRawX();
        int y = (int)event.getRawY();
        switch (event.getAction()) {
            case 0: {
                this.mStartX = x;
                this.mStartY = y;
                this.mLastY = y;
                this.mLastX = x;
                if (this.mEventListener == null) break;
                this.mEventListener.onDown(x, y);
                break;
            }
            case 2: {
                if (Math.abs(x - this.mStartX) < distance && Math.abs(y - this.mStartY) < distance) {
                    if (this.mState == TouchState.STATE_STOP) {
                        break;
                    }
                } else if (this.mState != TouchState.STATE_MOVE) {
                    this.mState = TouchState.STATE_MOVE;
                }
                if (this.mEventListener != null) {
                    this.mEventListener.onMove(this.mLastX, this.mLastY, x - this.mLastX, y - this.mLastY);
                }
                this.mLastY = y;
                this.mLastX = x;
                this.mState = TouchState.STATE_MOVE;
                break;
            }
            case 1: {
                if (this.mEventListener != null) {
                    this.mEventListener.onUp(x, y);
                }
                if (this.mState != TouchState.STATE_MOVE && event.getEventTime() - event.getDownTime() < 1000L) {
                    v.performClick();
                }
                this.mState = TouchState.STATE_STOP;
                break;
            }
        }
        return true;
    }

    public static interface OnTouchEventListener {
        public void onMove(int var1, int var2, int var3, int var4);

        public void onUp(int var1, int var2);

        public void onDown(int var1, int var2);
    }

    private static enum TouchState {
        STATE_MOVE,
        STATE_STOP;

    }
}

