/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.blockmonitor.core;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.text.TextUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public class StackSampler {
    private static final String TAG = "StackSampler";
    private static final int DEFAULT_SAMPLE_INTERVAL = 300;
    private static final int DEFAULT_MAX_ENTRY_COUNT = 100;
    private static final String SEPARATOR = "\r\n";
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.CHINESE);
    private AtomicBoolean mRunning = new AtomicBoolean(false);
    private HandlerThread mStackThread;
    private Handler mStackHandler;
    private LinkedHashMap<Long, String> sStackMap = new LinkedHashMap();
    private String mFilterCache;
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            StackSampler.this.dumpInfo();
            if (StackSampler.this.mRunning.get()) {
                StackSampler.this.mStackHandler.postDelayed(StackSampler.this.mRunnable, 300L);
            }
        }
    };

    public void init() {
        if (this.mStackThread == null) {
            this.mStackThread = new HandlerThread("BlockMonitor"){

                protected void onLooperPrepared() {
                    StackSampler.this.mStackHandler = new Handler(StackSampler.this.mStackThread.getLooper());
                }
            };
            this.mStackThread.start();
        }
    }

    public void startDump() {
        if (this.mStackHandler == null) {
            return;
        }
        if (this.mRunning.get()) {
            return;
        }
        this.mRunning.set(true);
        this.mStackHandler.removeCallbacks(this.mRunnable);
        this.mStackHandler.postDelayed(this.mRunnable, 300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getThreadStackEntries(long startTime, long endTime) {
        ArrayList<String> result2 = new ArrayList<String>();
        LinkedHashMap<Long, String> linkedHashMap = this.sStackMap;
        synchronized (linkedHashMap) {
            for (Long entryTime : this.sStackMap.keySet()) {
                if (startTime >= entryTime || entryTime >= endTime) continue;
                result2.add(TIME_FORMATTER.format(entryTime) + SEPARATOR + SEPARATOR + this.sStackMap.get(entryTime));
            }
        }
        return result2;
    }

    public void stopDump() {
        if (this.mStackHandler == null) {
            return;
        }
        if (!this.mRunning.get()) {
            return;
        }
        this.mRunning.set(false);
        this.mFilterCache = null;
        this.mStackHandler.removeCallbacks(this.mRunnable);
    }

    public void shutDown() {
        this.stopDump();
        if (this.mStackThread != null) {
            this.mStackThread.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        Thread thread = Looper.getMainLooper().getThread();
        for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
            stringBuilder.append(stackTraceElement.toString()).append(SEPARATOR);
        }
        LinkedHashMap<Long, String> linkedHashMap = this.sStackMap;
        synchronized (linkedHashMap) {
            if (this.sStackMap.size() == 100) {
                this.sStackMap.remove(this.sStackMap.keySet().iterator().next());
            }
            if (!this.shouldIgnore(stringBuilder)) {
                this.sStackMap.put(System.currentTimeMillis(), stringBuilder.toString());
            }
        }
    }

    private boolean shouldIgnore(StringBuilder builder) {
        if (TextUtils.equals((CharSequence)this.mFilterCache, (CharSequence)builder.toString())) {
            return true;
        }
        this.mFilterCache = builder.toString();
        return false;
    }
}

