/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.blockmonitor;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.blockmonitor.BlockListFragment;
import com.didichuxing.doraemonkit.kit.blockmonitor.core.BlockMonitorManager;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.core.SettingItem;
import com.didichuxing.doraemonkit.kit.core.SettingItemAdapter;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;

public class BlockMonitorFragment
extends BaseFragment {
    private static final String TAG = "BlockMonitorIndexFragment";
    public static final String KEY_JUMP_TO_LIST = "KEY_JUMP_TO_LIST";

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_block_monitor_index;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
    }

    private void initView() {
        boolean jump;
        HomeTitleBar title = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        title.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                BlockMonitorFragment.this.getActivity().finish();
            }
        });
        RecyclerView mSettingList = (RecyclerView)this.findViewById(R.id.setting_list);
        mSettingList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        SettingItemAdapter settingItemAdapter = new SettingItemAdapter(this.getContext());
        mSettingList.setAdapter((RecyclerView.Adapter)settingItemAdapter);
        settingItemAdapter.append(new SettingItem(R.string.dk_item_block_switch, BlockMonitorManager.getInstance().isRunning()));
        settingItemAdapter.append(new SettingItem(R.string.dk_item_block_goto_list));
        settingItemAdapter.append(new SettingItem(R.string.dk_item_block_mock));
        settingItemAdapter.setOnSettingItemSwitchListener(new SettingItemAdapter.OnSettingItemSwitchListener(){

            @Override
            public void onSettingItemSwitch(View view, SettingItem data, boolean on) {
                if (data.desc == R.string.dk_item_block_switch) {
                    if (on) {
                        BlockMonitorManager.getInstance().start();
                    } else {
                        BlockMonitorManager.getInstance().stop();
                    }
                }
            }
        });
        settingItemAdapter.setOnSettingItemClickListener(new SettingItemAdapter.OnSettingItemClickListener(){

            @Override
            public void onSettingItemClick(View view, SettingItem data) {
                if (data.desc == R.string.dk_item_block_goto_list) {
                    BlockMonitorFragment.this.showContent(BlockListFragment.class);
                } else if (data.desc == R.string.dk_item_block_mock) {
                    BlockMonitorFragment.this.mockBlock();
                }
            }
        });
        if (this.getArguments() != null && (jump = this.getArguments().getBoolean(KEY_JUMP_TO_LIST, false))) {
            this.showContent(BlockListFragment.class);
        }
    }

    private void mockBlock() {
        try {
            this.getView().postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }, 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onDestroy() {
        super.onDestroy();
    }
}

