/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.blockmonitor;

import android.content.Context;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.blockmonitor.bean.BlockInfo;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsRecyclerAdapter;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsViewBinder;

public class BlockListAdapter
extends AbsRecyclerAdapter<AbsViewBinder<BlockInfo>, BlockInfo> {
    private OnItemClickListener mListener;

    public BlockListAdapter(Context context) {
        super(context);
    }

    @Override
    protected AbsViewBinder<BlockInfo> createViewHolder(View view, int viewType) {
        return new ItemViewHolder(view);
    }

    @Override
    protected View createView(LayoutInflater inflater, ViewGroup parent, int viewType) {
        return inflater.inflate(R.layout.dk_item_block_list, parent, false);
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mListener = listener;
    }

    public static interface OnItemClickListener {
        public void onClick(BlockInfo var1);
    }

    private class ItemViewHolder
    extends AbsViewBinder<BlockInfo> {
        private TextView tvTime;
        private TextView tvTitle;

        public ItemViewHolder(View view) {
            super(view);
        }

        @Override
        protected void getViews() {
            this.tvTime = (TextView)this.getView(R.id.time);
            this.tvTitle = (TextView)this.getView(R.id.title);
        }

        @Override
        public void bind(BlockInfo blockInfoEx) {
        }

        @Override
        public void bind(final BlockInfo info, int position) {
            String index = BlockListAdapter.this.getItemCount() - position + ". ";
            String title = index + info.concernStackString + " " + this.getContext().getString(R.string.dk_block_class_has_blocked, new Object[]{String.valueOf(info.timeCost)});
            this.tvTitle.setText((CharSequence)title);
            String time = DateUtils.formatDateTime((Context)this.getContext(), (long)info.time, (int)17);
            this.tvTime.setText((CharSequence)time);
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (BlockListAdapter.this.mListener != null) {
                        BlockListAdapter.this.mListener.onClick(info);
                    }
                }
            });
        }
    }
}

