/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.datapick;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.didichuxing.doraemonkit.datapick.DataPickBean;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.util.FileIOUtils;
import com.didichuxing.doraemonkit.util.FileUtils;
import com.didichuxing.doraemonkit.util.GsonUtils;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.PathUtils;
import com.didichuxing.doraemonkit.volley.VolleyManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class DataPickManager {
    private static final String TAG = "DataPickManager";
    private List<DataPickBean.EventBean> events = new ArrayList<DataPickBean.EventBean>();
    private DataPickBean dataPickBean = new DataPickBean();
    private static int jsonFromFile = 100;
    private static int jsonFromMemory = 101;
    private String filePath = PathUtils.getInternalAppFilesPath() + File.separator + "dokit.json";

    public static DataPickManager getInstance() {
        return Holder.INSTANCE;
    }

    public void addData(@NonNull String eventName) {
        DataPickBean.EventBean eventBean = new DataPickBean.EventBean(eventName);
        if (this.events != null) {
            long lastSecondTime;
            long lastTime;
            this.events.add(eventBean);
            if (this.events.size() >= 10) {
                this.postData();
                return;
            }
            if (this.events.size() >= 2 && (lastTime = Long.parseLong(this.events.get(this.events.size() - 1).getTime())) - (lastSecondTime = Long.parseLong(this.events.get(this.events.size() - 2).getTime())) >= 60000L) {
                this.postData();
            }
        } else {
            this.events = new ArrayList<DataPickBean.EventBean>();
            this.events.add(eventBean);
        }
    }

    public void postData() {
        if (!DoKitManager.INSTANCE.getENABLE_UPLOAD()) {
            return;
        }
        String strJson = FileIOUtils.readFile2String((String)this.filePath);
        if (!TextUtils.isEmpty((CharSequence)strJson)) {
            try {
                this.realPost(jsonFromFile, strJson);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (this.events == null || this.events.size() == 0) {
            return;
        }
        this.dataPickBean.setEvents(this.events);
        strJson = GsonUtils.toJson((Object)this.dataPickBean);
        try {
            this.realPost(jsonFromMemory, strJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void realPost(final int from, String content) throws Exception {
        JsonObjectRequest requset = new JsonObjectRequest(1, "https://www.dokit.cn/pointData/addPointData", new JSONObject(content), (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                if (from == jsonFromFile) {
                    FileUtils.delete((String)DataPickManager.this.filePath);
                }
                if (from == jsonFromMemory) {
                    DataPickManager.this.events.clear();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                LogHelper.e(DataPickManager.TAG, "error===>" + error.getMessage());
            }
        });
        VolleyManager.INSTANCE.add(requset);
    }

    public void saveData2Local() {
        if (this.events == null || this.events.size() == 0) {
            return;
        }
        this.dataPickBean.setEvents(this.events);
        FileIOUtils.writeFileFromString((String)this.filePath, (String)GsonUtils.toJson((Object)this.dataPickBean));
    }

    private static class Holder {
        private static DataPickManager INSTANCE = new DataPickManager();

        private Holder() {
        }
    }
}

