/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.aop.bigimg.glide;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.didichuxing.doraemonkit.config.PerformanceSpInfoConfig;
import com.didichuxing.doraemonkit.kit.largepicture.LargePictureManager;
import com.didichuxing.doraemonkit.util.ConvertUtils;
import com.didichuxing.doraemonkit.util.ImageUtils;

public class DokitGlideRequestListener<R>
implements RequestListener<R> {
    private static final String TAG = "DokitGlideListener";

    public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<R> target, boolean isFirstResource) {
        return false;
    }

    public boolean onResourceReady(R resource, Object model, Target<R> target, DataSource dataSource, boolean isFirstResource) {
        try {
            if (PerformanceSpInfoConfig.isLargeImgOpen()) {
                if (resource instanceof Bitmap) {
                    Bitmap bitmap = (Bitmap)resource;
                    double imgSize = ConvertUtils.byte2MemorySize((long)bitmap.getByteCount(), (int)0x100000);
                    LargePictureManager.getInstance().saveImageInfo(model.toString(), imgSize, bitmap.getWidth(), bitmap.getHeight(), "Glide");
                } else if (resource instanceof BitmapDrawable) {
                    Bitmap bitmap = ImageUtils.drawable2Bitmap((Drawable)((BitmapDrawable)resource));
                    double imgSize = ConvertUtils.byte2MemorySize((long)bitmap.getByteCount(), (int)0x100000);
                    LargePictureManager.getInstance().saveImageInfo(model.toString(), imgSize, bitmap.getWidth(), bitmap.getHeight(), "Glide");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

