/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.tableview.style;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import com.didichuxing.doraemonkit.widget.tableview.intface.IStyle;
import com.didichuxing.doraemonkit.widget.tableview.utils.DensityUtils;

public class FontStyle
implements IStyle {
    private static int defaultFontSize = 12;
    private static int defaultFontColor = Color.parseColor((String)"#636363");
    private static Paint.Align defaultAlign = Paint.Align.CENTER;
    private int textSize;
    private int textColor;
    private Paint.Align align;

    public static void setDefaultTextSize(int defaultTextSize) {
        defaultFontSize = defaultTextSize;
    }

    public static void setDefaultTextAlign(Paint.Align align) {
        defaultAlign = align;
    }

    public static void setDefaultTextSpSize(Context context, int defaultTextSpSize) {
        defaultFontSize = DensityUtils.sp2px(context, defaultTextSpSize);
    }

    public static void setDefaultTextColor(int defaultTextColor) {
        defaultFontColor = defaultTextColor;
    }

    public FontStyle() {
    }

    public FontStyle(int textSize, int textColor) {
        this.textSize = textSize;
        this.textColor = textColor;
    }

    public FontStyle(Context context, int sp, int textColor) {
        this.textSize = DensityUtils.sp2px(context, sp);
        this.textColor = textColor;
    }

    public Paint.Align getAlign() {
        if (this.align == null) {
            return defaultAlign;
        }
        return this.align;
    }

    public FontStyle setAlign(Paint.Align align) {
        this.align = align;
        return this;
    }

    public int getTextSize() {
        if (this.textSize == 0) {
            return defaultFontSize;
        }
        return this.textSize;
    }

    public FontStyle setTextSize(int textSize) {
        this.textSize = textSize;
        return this;
    }

    public void setTextSpSize(Context context, int sp) {
        this.setTextSize(DensityUtils.sp2px(context, sp));
    }

    public int getTextColor() {
        if (this.textColor == 0) {
            return defaultFontColor;
        }
        return this.textColor;
    }

    public FontStyle setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    @Override
    public void fillPaint(Paint paint) {
        paint.setColor(this.getTextColor());
        paint.setTextAlign(this.getAlign());
        paint.setTextSize((float)this.getTextSize());
        paint.setStyle(Paint.Style.FILL);
    }
}

