/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.dialog;

import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.widget.dialog.DialogProvider;

public class UniversalDialogFragment
extends DialogFragment {
    private DialogProvider mProvider;

    public void setProvider(DialogProvider provider) {
        this.mProvider = provider;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, 0);
    }

    public int getTheme() {
        return R.style.DK_Dialog;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.getDialog().requestWindowFeature(1);
        if (this.mProvider != null) {
            this.setCancelable(this.mProvider.isCancellable());
        }
        Window window = this.getDialog().getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.gravity = this.getGravity();
        lp.width = this.getWidth();
        lp.height = this.getHeight();
        window.setAttributes(lp);
        return this.mProvider.createView(inflater, container);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        this.mProvider.onViewCreated(view);
    }

    public void onStart() {
        super.onStart();
        this.getDialog().getWindow().setLayout(this.getWidth(), this.getHeight());
        this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(this.getResources().getColor(17170445)));
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        this.mProvider.onCancel();
    }

    protected int getGravity() {
        return 17;
    }

    protected int getWidth() {
        return -2;
    }

    protected int getHeight() {
        return -2;
    }
}

