/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.picasso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.didichuxing.doraemonkit.picasso.DokitPicasso;
import com.didichuxing.doraemonkit.picasso.Request;
import com.didichuxing.doraemonkit.picasso.RequestHandler;
import com.didichuxing.doraemonkit.picasso.Utils;
import java.io.IOException;

class ResourceRequestHandler
extends RequestHandler {
    private final Context context;

    ResourceRequestHandler(Context context) {
        this.context = context;
    }

    @Override
    public boolean canHandleRequest(Request data) {
        if (data.resourceId != 0) {
            return true;
        }
        return "android.resource".equals(data.uri.getScheme());
    }

    @Override
    public RequestHandler.Result load(Request request2, int networkPolicy) throws IOException {
        Resources res = Utils.getResources(this.context, request2);
        int id2 = Utils.getResourceId(res, request2);
        return new RequestHandler.Result(ResourceRequestHandler.decodeResource(res, id2, request2), DokitPicasso.LoadedFrom.DISK);
    }

    private static Bitmap decodeResource(Resources resources, int id2, Request data) {
        BitmapFactory.Options options = ResourceRequestHandler.createBitmapOptions(data);
        if (ResourceRequestHandler.requiresInSampleSize(options)) {
            BitmapFactory.decodeResource((Resources)resources, (int)id2, (BitmapFactory.Options)options);
            ResourceRequestHandler.calculateInSampleSize(data.targetWidth, data.targetHeight, options, data);
        }
        return BitmapFactory.decodeResource((Resources)resources, (int)id2, (BitmapFactory.Options)options);
    }
}

