/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.timecounter.instrumentation;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.didichuxing.doraemonkit.kit.timecounter.TimeCounterManager;
import com.didichuxing.doraemonkit.util.Reflector;

class ProxyHandlerCallback
implements Handler.Callback {
    private static final String TAG = "ProxyHandlerCallback";
    private static final int LAUNCH_ACTIVITY = 100;
    private static final int PAUSE_ACTIVITY = 101;
    private static final int EXECUTE_TRANSACTION = 159;
    private static final String LAUNCH_ITEM_CLASS = "android.app.servertransaction.ResumeActivityItem";
    private static final String PAUSE_ITEM_CLASS = "android.app.servertransaction.PauseActivityItem";
    private final Handler.Callback mOldCallback;
    public final Handler mHandler;

    ProxyHandlerCallback(Handler.Callback oldCallback, Handler handler) {
        this.mOldCallback = oldCallback;
        this.mHandler = handler;
    }

    public boolean handleMessage(Message msg) {
        int msgType = this.preDispatch(msg);
        if (this.mOldCallback != null && this.mOldCallback.handleMessage(msg)) {
            this.postDispatch(msgType);
            return true;
        }
        this.mHandler.handleMessage(msg);
        this.postDispatch(msgType);
        return true;
    }

    private int preDispatch(Message msg) {
        switch (msg.what) {
            case 100: {
                TimeCounterManager.get().onActivityLaunch();
                break;
            }
            case 101: {
                TimeCounterManager.get().onActivityPause();
                break;
            }
            case 159: {
                return this.handlerActivity(msg);
            }
        }
        return msg.what;
    }

    private int handlerActivity(Message msg) {
        Object obj = msg.obj;
        Object activityCallback = ((Reflector.QuietReflector)Reflector.QuietReflector.with(obj).method("getLifecycleStateRequest", new Class[0])).call(new Object[0]);
        if (activityCallback != null) {
            String transactionName = activityCallback.getClass().getCanonicalName();
            if (TextUtils.equals((CharSequence)transactionName, (CharSequence)LAUNCH_ITEM_CLASS)) {
                TimeCounterManager.get().onActivityLaunch();
                return 100;
            }
            if (TextUtils.equals((CharSequence)transactionName, (CharSequence)PAUSE_ITEM_CLASS)) {
                TimeCounterManager.get().onActivityPause();
                return 101;
            }
        }
        return msg.what;
    }

    private void postDispatch(int msgType) {
        switch (msgType) {
            case 100: {
                TimeCounterManager.get().onActivityLaunched();
                break;
            }
            case 101: {
                TimeCounterManager.get().onActivityPaused();
                break;
            }
        }
    }
}

