/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.parameter;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.CheckBox;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.app.ActivityCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.core.SettingItem;
import com.didichuxing.doraemonkit.kit.core.SettingItemAdapter;
import com.didichuxing.doraemonkit.kit.performance.PerformanceDokitViewManager;
import com.didichuxing.doraemonkit.kit.performance.PerformanceFragmentCloseListener;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbsParameterFragment
extends BaseFragment
implements PerformanceFragmentCloseListener {
    private SettingItemAdapter mSettingItemAdapter;
    private RecyclerView mSettingList;
    private static final String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    private static final int REQUEST_EXTERNAL_STORAGE = 2;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_parameter;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
    }

    @StringRes
    protected abstract int getTitle();

    protected abstract int getPerformanceType();

    protected abstract Collection<SettingItem> getSettingItems(List<SettingItem> var1);

    protected abstract SettingItemAdapter.OnSettingItemSwitchListener getItemSwitchListener();

    protected abstract SettingItemAdapter.OnSettingItemClickListener getItemClickListener();

    protected void openChartPage(@StringRes int title, int type) {
        PerformanceDokitViewManager.open(type, this.getString(title), this);
    }

    protected void closeChartPage() {
        PerformanceDokitViewManager.close(this.getPerformanceType(), this.getString(this.getTitle()));
    }

    private void initView() {
        HomeTitleBar titleBar = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        titleBar.setTitle(this.getTitle());
        titleBar.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                AbsParameterFragment.this.getActivity().finish();
            }
        });
        this.mSettingList = (RecyclerView)this.findViewById(R.id.setting_list);
        this.mSettingList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mSettingItemAdapter = new SettingItemAdapter(this.getContext());
        this.mSettingItemAdapter.append(this.getSettingItems(new ArrayList<SettingItem>()));
        this.mSettingItemAdapter.setOnSettingItemSwitchListener(new SettingItemAdapter.OnSettingItemSwitchListener(){

            @Override
            public void onSettingItemSwitch(View view, SettingItem data, boolean on) {
                if (on && !AbsParameterFragment.this.ownPermissionCheck()) {
                    if (view instanceof CheckBox) {
                        ((CheckBox)view).setChecked(false);
                    }
                    AbsParameterFragment.this.requestPermissions(PERMISSIONS_STORAGE, 2);
                    return;
                }
                SettingItemAdapter.OnSettingItemSwitchListener itemSwitchListener = AbsParameterFragment.this.getItemSwitchListener();
                if (itemSwitchListener != null) {
                    itemSwitchListener.onSettingItemSwitch(view, data, on);
                }
            }
        });
        this.mSettingItemAdapter.setOnSettingItemClickListener(new SettingItemAdapter.OnSettingItemClickListener(){

            @Override
            public void onSettingItemClick(View view, SettingItem data) {
                if (!AbsParameterFragment.this.ownPermissionCheck()) {
                    AbsParameterFragment.this.requestPermissions(PERMISSIONS_STORAGE, 2);
                    return;
                }
                SettingItemAdapter.OnSettingItemClickListener itemClickListener = AbsParameterFragment.this.getItemClickListener();
                if (itemClickListener != null) {
                    itemClickListener.onSettingItemClick(view, data);
                }
            }
        });
        this.mSettingList.setAdapter((RecyclerView.Adapter)this.mSettingItemAdapter);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 2) {
            for (int grantResult : grantResults) {
                if (grantResult != -1) continue;
                ToastUtils.showShort((int)R.string.dk_error_tips_permissions_less);
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    private boolean ownPermissionCheck() {
        int permission = ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        return permission == 0;
    }

    @Override
    public void onClose(int performanceType) {
        if (performanceType != this.getPerformanceType()) {
            return;
        }
        if (this.mSettingList == null || this.mSettingList.isComputingLayout()) {
            return;
        }
        if (this.mSettingItemAdapter == null) {
            return;
        }
        if (!((SettingItem)this.mSettingItemAdapter.getData().get((int)0)).isChecked) {
            return;
        }
        ((SettingItem)this.mSettingItemAdapter.getData().get((int)0)).isChecked = false;
        this.mSettingItemAdapter.notifyItemChanged(0);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mSettingItemAdapter = null;
    }

    public void onDestroy() {
        super.onDestroy();
        PerformanceDokitViewManager.onPerformanceSettingFragmentDestroy(this);
    }
}

