/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.didichuxing.doraemonkit.DoKitEnv;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.loginfo.LogExportDialog;
import com.didichuxing.doraemonkit.kit.network.bean.NetworkRecord;
import com.didichuxing.doraemonkit.kit.network.bean.Request;
import com.didichuxing.doraemonkit.kit.network.bean.Response;
import com.didichuxing.doraemonkit.kit.network.utils.ByteUtil;
import com.didichuxing.doraemonkit.util.AppUtils;
import com.didichuxing.doraemonkit.util.DoKitFileUtil;
import com.didichuxing.doraemonkit.util.FileIOUtils;
import com.didichuxing.doraemonkit.util.FileUtils;
import com.didichuxing.doraemonkit.util.PathUtils;
import com.didichuxing.doraemonkit.util.ThreadUtils;
import com.didichuxing.doraemonkit.util.TimeUtils;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.dialog.DialogProvider;
import com.didichuxing.doraemonkit.widget.dialog.UniversalDialogFragment;
import com.didichuxing.doraemonkit.widget.jsonviewer.JsonRecyclerView;
import java.io.File;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkDetailView
extends LinearLayout {
    private SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss:SSS");
    private TextView url;
    private TextView method;
    private TextView size;
    private TextView header;
    private TextView body;
    private TextView time;
    private TextView diverTime;
    private TextView diverHeader;
    private TextView diverBody;
    private TextView diverFormat;
    private TextView diverExport;
    private JsonRecyclerView jsonView;
    private ClipboardManager mClipboard;

    public NetworkDetailView(Context context) {
        super(context);
        NetworkDetailView.inflate((Context)context, (int)R.layout.dk_view_network_request, (ViewGroup)this);
        this.mClipboard = (ClipboardManager)context.getSystemService("clipboard");
        this.url = (TextView)this.findViewById(R.id.tv_url);
        this.method = (TextView)this.findViewById(R.id.tv_method);
        this.size = (TextView)this.findViewById(R.id.tv_data_size);
        this.header = (TextView)this.findViewById(R.id.tv_header);
        this.body = (TextView)this.findViewById(R.id.tv_body);
        this.time = (TextView)this.findViewById(R.id.tv_time);
        this.diverTime = (TextView)this.findViewById(R.id.diver_time);
        this.diverHeader = (TextView)this.findViewById(R.id.diver_header);
        this.diverBody = (TextView)this.findViewById(R.id.diver_body);
        this.diverFormat = (TextView)this.findViewById(R.id.diver_format);
        this.diverExport = (TextView)this.findViewById(R.id.diver_export);
        this.jsonView = (JsonRecyclerView)this.findViewById(R.id.json_body);
        this.body.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ClipData clipData = ClipData.newPlainText((CharSequence)"Label", (CharSequence)NetworkDetailView.this.body.getText());
                NetworkDetailView.this.mClipboard.setPrimaryClip(clipData);
                Toast.makeText((Context)NetworkDetailView.this.getContext(), (CharSequence)"copy success", (int)0).show();
                return false;
            }
        });
    }

    public NetworkDetailView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public void bindRequest(NetworkRecord record) {
        this.diverTime.setText(R.string.dk_network_detail_title_request_time);
        this.diverHeader.setText(R.string.dk_network_detail_title_request_header);
        this.diverBody.setText(R.string.dk_network_detail_title_request_body);
        this.diverFormat.setVisibility(8);
        this.diverExport.setVisibility(8);
        this.jsonView.setVisibility(8);
        this.body.setVisibility(0);
        if (record.mRequest != null) {
            Request request2 = record.mRequest;
            this.url.setText((CharSequence)request2.url);
            this.method.setText((CharSequence)request2.method);
            try {
                this.header.setText((CharSequence)URLDecoder.decode(request2.headers, "utf-8"));
            }
            catch (Exception e) {
                this.header.setText((CharSequence)request2.headers);
            }
            this.time.setText((CharSequence)this.mDateFormat.format(new Date(record.startTime)));
            this.size.setText((CharSequence)ByteUtil.getPrintSize(record.requestLength));
            try {
                String strBody = TextUtils.isEmpty((CharSequence)request2.postData) ? "NULL" : request2.postData;
                strBody = URLDecoder.decode(strBody, "utf-8");
                this.body.setText((CharSequence)strBody);
            }
            catch (Exception e) {
                this.body.setText((CharSequence)(TextUtils.isEmpty((CharSequence)request2.postData) ? "NULL" : request2.postData));
            }
        }
    }

    public void bindResponse(final NetworkRecord record) {
        this.diverTime.setText(R.string.dk_network_detail_title_response_time);
        this.diverHeader.setText(R.string.dk_network_detail_title_response_header);
        this.diverBody.setText(R.string.dk_network_detail_title_response_body);
        this.diverExport.setVisibility(0);
        this.diverExport.setText((CharSequence)"\u5bfc\u51fa");
        this.diverFormat.setVisibility(0);
        this.diverFormat.setText((CharSequence)"unFormat");
        this.jsonView.setVisibility(0);
        this.jsonView.setTextSize(16.0f);
        this.jsonView.setScaleEnable(false);
        this.body.setVisibility(8);
        this.diverFormat.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (NetworkDetailView.this.body.getVisibility() == 0) {
                    String strBody = TextUtils.isEmpty((CharSequence)record.mResponseBody) ? "NULL" : record.mResponseBody;
                    try {
                        new JSONObject(strBody);
                        NetworkDetailView.this.jsonView.setVisibility(0);
                        NetworkDetailView.this.body.setVisibility(8);
                        NetworkDetailView.this.diverFormat.setText((CharSequence)"unFormat");
                    }
                    catch (JSONException e) {
                        NetworkDetailView.this.jsonView.setVisibility(8);
                        NetworkDetailView.this.body.setVisibility(0);
                        NetworkDetailView.this.body.setText((CharSequence)strBody);
                        NetworkDetailView.this.diverFormat.setText((CharSequence)"format");
                        ToastUtils.showShort((CharSequence)"format error");
                    }
                } else {
                    String strBody = TextUtils.isEmpty((CharSequence)record.mResponseBody) ? "NULL" : record.mResponseBody;
                    NetworkDetailView.this.body.setText((CharSequence)strBody);
                    NetworkDetailView.this.diverFormat.setText((CharSequence)"format");
                    NetworkDetailView.this.jsonView.setVisibility(8);
                    NetworkDetailView.this.body.setVisibility(0);
                }
            }
        });
        this.diverExport.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String strBody;
                String string2 = strBody = TextUtils.isEmpty((CharSequence)record.mResponseBody) ? "NULL" : record.mResponseBody;
                if (strBody.equals("NULL")) {
                    ToastUtils.showShort((CharSequence)"\u6682\u65e0\u54cd\u5e94\u4f53\u53ef\u4ee5\u5bfc\u51fa");
                    return;
                }
                LogExportDialog logExportDialog = new LogExportDialog(new Object(), null);
                logExportDialog.setOnButtonClickListener(new LogExportDialog.OnButtonClickListener(){

                    @Override
                    public void onSaveClick(LogExportDialog dialog) {
                        NetworkDetailView.this.export2File(100, strBody);
                        dialog.dismiss();
                    }

                    @Override
                    public void onShareClick(LogExportDialog dialog) {
                        NetworkDetailView.this.export2File(101, strBody);
                        dialog.dismiss();
                    }
                });
                NetworkDetailView.this.showDialog(logExportDialog);
            }
        });
        if (record.mResponse != null) {
            Response response = record.mResponse;
            Request request2 = record.mRequest;
            this.url.setText((CharSequence)response.url);
            this.method.setText((CharSequence)request2.method);
            this.header.setText((CharSequence)response.headers);
            this.time.setText((CharSequence)this.mDateFormat.format(new Date(record.endTime)));
            this.size.setText((CharSequence)ByteUtil.getPrintSize(record.responseLength));
            String strBody = TextUtils.isEmpty((CharSequence)record.mResponseBody) ? "NULL" : record.mResponseBody;
            try {
                new JSONObject(strBody);
                this.jsonView.bindJson(strBody);
            }
            catch (JSONException e) {
                e.printStackTrace();
                this.body.setVisibility(0);
                this.jsonView.setVisibility(8);
                this.diverFormat.setText((CharSequence)"format");
                this.body.setText((CharSequence)strBody);
            }
        }
    }

    private void export2File(final int operateType, final String responseBody) {
        ToastUtils.showShort((CharSequence)"\u65e5\u5fd7\u4fdd\u5b58\u4e2d,\u8bf7\u7a0d\u540e...");
        final String logPath = PathUtils.getInternalAppFilesPath() + File.separator + AppUtils.getAppName() + "_response_" + TimeUtils.getNowString((DateFormat)new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss")) + ".txt";
        final File logFile = new File(logPath);
        ThreadUtils.executeByCpu((ThreadUtils.Task)new ThreadUtils.Task<Boolean>(){

            public Boolean doInBackground() throws Throwable {
                try {
                    FileIOUtils.writeFileFromString((File)logFile, (String)responseBody, (boolean)true);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            public void onSuccess(Boolean result2) {
                if (result2.booleanValue()) {
                    ToastUtils.showShort((CharSequence)("\u6587\u4ef6\u4fdd\u5b58\u5728:" + logPath));
                    if (operateType == 101) {
                        DoKitFileUtil.systemShare((Context)DoKitEnv.requireApp(), logFile);
                    }
                }
            }

            public void onCancel() {
                if (logFile.exists()) {
                    FileUtils.delete((File)logFile);
                }
                ToastUtils.showShort((CharSequence)"\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25");
            }

            public void onFail(Throwable t) {
                if (logFile.exists()) {
                    FileUtils.delete((File)logFile);
                }
                ToastUtils.showShort((CharSequence)"\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25");
            }
        });
    }

    private void showDialog(DialogProvider provider) {
        if (this.getContext() == null || !(this.getContext() instanceof Activity)) {
            return;
        }
        Activity activity = (Activity)this.getContext();
        UniversalDialogFragment dialog = new UniversalDialogFragment();
        provider.setHost(dialog);
        dialog.setProvider(provider);
        provider.show(((FragmentActivity)activity).getSupportFragmentManager());
    }
}

