/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.okhttp;

import com.didichuxing.doraemonkit.kit.network.core.NetworkInterpreter;
import com.didichuxing.doraemonkit.kit.network.core.RequestBodyHelper;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public class OkHttpInspectorRequest
implements NetworkInterpreter.InspectorRequest {
    private final int mRequestId;
    private final Request mRequest;
    private RequestBodyHelper mRequestBodyHelper;

    public OkHttpInspectorRequest(int requestId, Request request2, RequestBodyHelper requestBodyHelper) {
        this.mRequestId = requestId;
        this.mRequest = request2;
        this.mRequestBodyHelper = requestBodyHelper;
    }

    @Override
    public int id() {
        return this.mRequestId;
    }

    @Override
    public String url() {
        return this.mRequest.url().toString();
    }

    @Override
    public String method() {
        return this.mRequest.method();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] body() throws IOException {
        RequestBody body = this.mRequest.body();
        if (body == null) {
            return null;
        }
        OutputStream out = this.mRequestBodyHelper.createBodySink(this.firstHeaderValue("Content-Encoding"));
        try (BufferedSink bufferedSink = Okio.buffer((Sink)Okio.sink((OutputStream)out));){
            body.writeTo(bufferedSink);
        }
        return this.mRequestBodyHelper.getDisplayBody();
    }

    @Override
    public int headerCount() {
        return this.mRequest.headers().size();
    }

    @Override
    public String headerName(int index) {
        return this.mRequest.headers().name(index);
    }

    @Override
    public String headerValue(int index) {
        return this.mRequest.headers().value(index);
    }

    @Override
    public String firstHeaderValue(String name) {
        return this.mRequest.header(name);
    }
}

