/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.loginfo.helper;

import com.didichuxing.doraemonkit.kit.loginfo.helper.RuntimeHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LogcatHelper {
    private static final String TAG = "LogcatHelper";
    public static final String BUFFER_MAIN = "main";
    public static final String BUFFER_EVENTS = "events";
    public static final String BUFFER_RADIO = "radio";

    public static Process getLogcatProcess(String buffer) throws IOException {
        List<String> args = LogcatHelper.getLogcatArgs(buffer);
        return RuntimeHelper.exec(args);
    }

    private static List<String> getLogcatArgs(String buffer) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("logcat", "-v", "time"));
        if (!buffer.equals(BUFFER_MAIN)) {
            args.add("-b");
            args.add(buffer);
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLastLogLine(String buffer) {
        Process dumpLogcatProcess = null;
        BufferedReader reader = null;
        String result2 = null;
        try {
            String line;
            List<String> args = LogcatHelper.getLogcatArgs(buffer);
            args.add("-d");
            dumpLogcatProcess = RuntimeHelper.exec(args);
            reader = new BufferedReader(new InputStreamReader(dumpLogcatProcess.getInputStream()), 8192);
            while ((line = reader.readLine()) != null) {
                result2 = line;
            }
            if (dumpLogcatProcess == null) return result2;
        }
        catch (IOException e) {
            e.printStackTrace();
            return result2;
        }
        finally {
            if (dumpLogcatProcess != null) {
                RuntimeHelper.destroy(dumpLogcatProcess);
            }
        }
        RuntimeHelper.destroy(dumpLogcatProcess);
        return result2;
    }
}

