/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.lbs.preset;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.kit.lbs.common.Constants;
import com.didichuxing.doraemonkit.kit.lbs.common.LocInfo;
import com.didichuxing.doraemonkit.kit.lbs.preset.MockLocList;

public class FloatGpsPresetMockCache {
    public static LocInfo sMockLocInfo = null;
    public static MockLocList sMockLocationList = new MockLocList();
    static LocInfo sCustomLocInfo = new LocInfo("\u81ea\u5b9a\u4e49\u70b9", 40.06, 116.233);

    public FloatGpsPresetMockCache() {
        if (!sMockLocationList.contains(sCustomLocInfo)) {
            sMockLocationList.add(0, sCustomLocInfo);
        }
    }

    public static void addMockLocConfig(LocInfo ... locInfos) {
        for (LocInfo locInfo : locInfos) {
            if (sMockLocationList.contains(locInfo)) continue;
            sMockLocationList.add(locInfo);
        }
    }

    public static void updateCustomMockLocation(double latitude, double longitude) {
        FloatGpsPresetMockCache.sCustomLocInfo.lat = latitude;
        FloatGpsPresetMockCache.sCustomLocInfo.lng = longitude;
        if (!sMockLocationList.contains(sCustomLocInfo)) {
            sMockLocationList.add(0, sCustomLocInfo);
        }
        FloatGpsPresetMockCache.setMockLocConfig(sCustomLocInfo);
    }

    public static void addMockLocationConfigWithJson(String jsonStr) {
        MockLocList locationList = (MockLocList)Constants.GSON.fromJson(jsonStr, MockLocList.class);
        if (locationList == null) {
            return;
        }
        for (LocInfo locInfo : locationList) {
            FloatGpsPresetMockCache.addMockLocConfig(locInfo);
        }
    }

    @Nullable
    public static LocInfo getMockLocConfig() {
        if (sMockLocInfo != null) {
            return sMockLocInfo;
        }
        String configLocalJson = Constants.loadLocationConfigJson();
        if (!TextUtils.isEmpty((CharSequence)configLocalJson)) {
            sMockLocInfo = LocInfo.fromGson(configLocalJson);
        }
        return sMockLocInfo;
    }

    public static void setMockLocConfig(LocInfo locInfo) {
        sMockLocInfo = locInfo;
        Constants.saveLocationConfigJson(locInfo.toGson());
    }
}

