/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.largepicture;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.didichuxing.doraemonkit.DoKitEnv;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.largepicture.LargeImageInfo;
import com.didichuxing.doraemonkit.picasso.DokitPicasso;
import com.didichuxing.doraemonkit.picasso.MemoryPolicy;
import com.didichuxing.doraemonkit.util.ConvertUtils;
import com.didichuxing.doraemonkit.util.DoKitClipboardUtils;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsRecyclerAdapter;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsViewBinder;
import java.text.DecimalFormat;

public class LargeImageListAdapter
extends AbsRecyclerAdapter<AbsViewBinder<LargeImageInfo>, LargeImageInfo> {
    private DecimalFormat mDecimalFormat = new DecimalFormat("#0.00");

    public LargeImageListAdapter(Context context) {
        super(context);
    }

    @Override
    protected AbsViewBinder<LargeImageInfo> createViewHolder(View view, int viewType) {
        return new ItemViewHolder(view);
    }

    @Override
    protected View createView(LayoutInflater inflater, ViewGroup parent, int viewType) {
        return inflater.inflate(R.layout.dk_item_large_img_list, parent, false);
    }

    private class ItemViewHolder
    extends AbsViewBinder<LargeImageInfo> {
        private ImageView iv;
        private TextView tvLink;
        private TextView tvFrameWork;
        private TextView tvFileSize;
        private TextView tvMemorySize;
        private TextView tvSize;
        private Button btnCopy;

        public ItemViewHolder(View view) {
            super(view);
        }

        @Override
        protected void getViews() {
            this.iv = (ImageView)this.getView(R.id.iv);
            this.tvLink = (TextView)this.getView(R.id.tv_link);
            this.tvFrameWork = (TextView)this.getView(R.id.tv_framework);
            this.tvFileSize = (TextView)this.getView(R.id.tv_file_size);
            this.tvMemorySize = (TextView)this.getView(R.id.tv_memory_size);
            this.tvSize = (TextView)this.getView(R.id.tv_size);
            this.btnCopy = (Button)this.getView(R.id.btn_copy);
        }

        @Override
        public void bind(final LargeImageInfo largeImageInfo) {
            try {
                int resourceUrl = Integer.parseInt(largeImageInfo.getUrl());
                DokitPicasso.with((Context)DoKitEnv.requireApp()).load(resourceUrl).memoryPolicy(MemoryPolicy.NO_CACHE, new MemoryPolicy[0]).resize(ConvertUtils.dp2px((float)100.0f), ConvertUtils.dp2px((float)100.0f)).centerCrop().into(this.iv);
                this.tvLink.setText((CharSequence)("resource id:" + resourceUrl));
            }
            catch (Exception e) {
                DokitPicasso.with((Context)DoKitEnv.requireApp()).load(largeImageInfo.getUrl()).memoryPolicy(MemoryPolicy.NO_CACHE, new MemoryPolicy[0]).resize(ConvertUtils.dp2px((float)100.0f), ConvertUtils.dp2px((float)100.0f)).centerCrop().into(this.iv);
                this.tvLink.setText((CharSequence)largeImageInfo.getUrl());
            }
            if (largeImageInfo.getMemorySize() == 0.0) {
                this.tvFrameWork.setText((CharSequence)String.format("framework:%s", "network"));
                this.tvMemorySize.setVisibility(8);
                this.tvSize.setVisibility(8);
            } else {
                this.tvFrameWork.setText((CharSequence)String.format("framework:%s", largeImageInfo.getFramework()));
                this.tvMemorySize.setVisibility(0);
                this.tvSize.setVisibility(0);
            }
            if (largeImageInfo.getFileSize() == 0.0) {
                this.tvFileSize.setVisibility(8);
            } else {
                this.tvFileSize.setVisibility(0);
            }
            this.tvFileSize.setText((CharSequence)String.format("fileSize:%s", LargeImageListAdapter.this.mDecimalFormat.format(largeImageInfo.getFileSize()) + "KB"));
            this.tvMemorySize.setText((CharSequence)String.format("memorySize:%s", LargeImageListAdapter.this.mDecimalFormat.format(largeImageInfo.getMemorySize()) + "MB"));
            this.tvSize.setText((CharSequence)String.format("width:%s   height:%s", largeImageInfo.getWidth(), largeImageInfo.getHeight()));
            this.btnCopy.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DoKitClipboardUtils.copyUri(Uri.parse((String)largeImageInfo.getUrl()));
                    ToastUtils.showShort((CharSequence)"image url  has copied");
                }
            });
        }
    }
}

