/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.gpsmock;

import android.content.Context;
import android.location.GnssStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.didichuxing.doraemonkit.kit.gpsmock.BaseServiceHooker;
import com.didichuxing.doraemonkit.kit.gpsmock.GpsMockManager;
import com.didichuxing.doraemonkit.kit.gpsmock.GpsMockProxyManager;
import com.didichuxing.doraemonkit.kit.gpsmock.MethodHandler;
import com.didichuxing.doraemonkit.util.ReflectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class LocationHooker
extends BaseServiceHooker {
    private static final String TAG = "LocationHooker";

    @Override
    public String serviceName() {
        return "location";
    }

    @Override
    public String stubName() {
        return "android.location.ILocationManager$Stub";
    }

    @Override
    @NonNull
    public Map<String, MethodHandler> registerMethodHandlers() {
        HashMap<String, MethodHandler> methodHandlers = new HashMap<String, MethodHandler>();
        methodHandlers.put("requestLocationUpdates", new RequestLocationUpdatesMethodHandler());
        methodHandlers.put("getLastLocation", new GetLastLocationMethodHandler());
        methodHandlers.put("registerGnssStatusCallback", new RegisterGnssStatusCallbackMethodHandler());
        return methodHandlers;
    }

    @Override
    public void replaceBinderProxy(Context context, IBinder proxy) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        if (this.getMBinderStubProxy() != null) {
            ReflectUtils.reflect((Object)locationManager).field("mService", (Object)this.getMBinderStubProxy());
        }
    }

    private static Location buildValidLocation(String provider) {
        if (TextUtils.isEmpty((CharSequence)provider)) {
            provider = "gps";
        }
        Location validLocation = new Location(provider);
        validLocation.setAccuracy(5.36f);
        validLocation.setBearing(315.0f);
        if (Build.VERSION.SDK_INT >= 26) {
            validLocation.setBearingAccuracyDegrees(52.285362f);
        }
        validLocation.setSpeed(0.79f);
        if (Build.VERSION.SDK_INT >= 26) {
            validLocation.setSpeedAccuracyMetersPerSecond(0.9462558f);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            validLocation.setVerticalAccuracyMeters(8.0f);
        }
        validLocation.setTime(System.currentTimeMillis());
        if (Build.VERSION.SDK_INT >= 17) {
            validLocation.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
        }
        return validLocation;
    }

    @RequiresApi(api=24)
    private static class GnssStatusCallbackProxy
    extends GnssStatus.Callback {
        GnssStatus.Callback mCallback;

        public GnssStatusCallbackProxy(GnssStatus.Callback mCallback) {
            this.mCallback = mCallback;
        }

        public void onStarted() {
            if (this.mCallback != null) {
                this.mCallback.onStarted();
            }
        }

        public void onStopped() {
            if (this.mCallback != null) {
                this.mCallback.onStopped();
            }
        }

        public void onFirstFix(int ttffMillis) {
            if (this.mCallback != null) {
                this.mCallback.onFirstFix(ttffMillis);
            }
        }

        public void onSatelliteStatusChanged(GnssStatus status) {
            if (this.mCallback != null) {
                this.mCallback.onSatelliteStatusChanged(status);
            }
        }
    }

    static class RequestLocationUpdatesMethodHandler
    extends MethodHandler {
        RequestLocationUpdatesMethodHandler() {
        }

        @Override
        public Object onInvoke(Object originService, Method method, Object[] args) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
            try {
                if (!GpsMockManager.getInstance().isMocking()) {
                    return method.invoke(originService, args);
                }
                Object listenerTransport = args[1];
                Field mListenerField = listenerTransport.getClass().getDeclaredField("mListener");
                mListenerField.setAccessible(true);
                LocationListener locationListener = (LocationListener)mListenerField.get(listenerTransport);
                LocationListenerProxy locationListenerProxy = new LocationListenerProxy(locationListener);
                mListenerField.set(listenerTransport, locationListenerProxy);
                mListenerField.setAccessible(false);
                return method.invoke(originService, args);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class LocationListenerProxy
    implements LocationListener {
        LocationListener locationListener;

        private LocationListenerProxy(LocationListener locationListener) {
            this.locationListener = locationListener;
            GpsMockProxyManager.INSTANCE.addLocationListenerProxy(this);
        }

        public void onLocationChanged(Location location) {
            if (this.locationListener != null) {
                if (GpsMockManager.getInstance().isMocking()) {
                    location.setLongitude(GpsMockManager.getInstance().getLongitude());
                    location.setLatitude(GpsMockManager.getInstance().getLatitude());
                    location.setTime(System.currentTimeMillis());
                }
                this.locationListener.onLocationChanged(location);
            }
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            if (this.locationListener != null) {
                this.locationListener.onStatusChanged(provider, status, extras);
            }
        }

        public void onProviderEnabled(String provider) {
            if (this.locationListener != null) {
                this.locationListener.onProviderEnabled(provider);
            }
        }

        public void onProviderDisabled(String provider) {
            if (this.locationListener != null) {
                this.locationListener.onProviderDisabled(provider);
            }
        }
    }

    static class RegisterGnssStatusCallbackMethodHandler
    extends MethodHandler {
        RegisterGnssStatusCallbackMethodHandler() {
        }

        @Override
        public Object onInvoke(Object originObject, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
            if (!GpsMockManager.getInstance().isMocking()) {
                return method.invoke(originObject, args);
            }
            if (Build.VERSION.SDK_INT >= 24) {
                Object gnssStatusListenerTransport = args[0];
                GnssStatus.Callback callback = (GnssStatus.Callback)ReflectUtils.reflect((Object)gnssStatusListenerTransport).field("mGnssCallback").get();
                GnssStatusCallbackProxy callbackProxy = new GnssStatusCallbackProxy(callback);
                ReflectUtils.reflect((Object)gnssStatusListenerTransport).field("mGnssCallback", (Object)callbackProxy);
            }
            return method.invoke(originObject, args);
        }
    }

    static class GetLastLocationMethodHandler
    extends MethodHandler {
        GetLastLocationMethodHandler() {
        }

        @Override
        public Object onInvoke(Object originObject, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
            if (!GpsMockManager.getInstance().isMocking()) {
                return method.invoke(originObject, args);
            }
            Location lastLocation = (Location)method.invoke(originObject, args);
            if (lastLocation == null) {
                lastLocation = LocationHooker.buildValidLocation(null);
            }
            lastLocation.setLongitude(GpsMockManager.getInstance().getLongitude());
            lastLocation.setLatitude(GpsMockManager.getInstance().getLatitude());
            lastLocation.setTime(System.currentTimeMillis());
            if (Build.VERSION.SDK_INT >= 17) {
                lastLocation.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
            }
            return lastLocation;
        }
    }

    static class GetLastKnownLocationMethodHandler
    extends MethodHandler {
        GetLastKnownLocationMethodHandler() {
        }

        @Override
        public Object onInvoke(Object originObject, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
            if (!GpsMockManager.getInstance().isMocking()) {
                return method.invoke(originObject, args);
            }
            Location lastKnownLocation = (Location)method.invoke(originObject, args);
            if (lastKnownLocation == null) {
                String provider = (String)args[0].getClass().getDeclaredMethod("getProvider", new Class[0]).invoke(args[0], new Object[0]);
                lastKnownLocation = LocationHooker.buildValidLocation(provider);
            }
            lastKnownLocation.setLongitude(GpsMockManager.getInstance().getLongitude());
            lastKnownLocation.setLatitude(GpsMockManager.getInstance().getLatitude());
            lastKnownLocation.setTime(System.currentTimeMillis());
            if (Build.VERSION.SDK_INT >= 17) {
                lastKnownLocation.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
            }
            return lastKnownLocation;
        }
    }
}

