/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.fileexplorer;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.Switch;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.fileexplorer.SpBean;
import com.didichuxing.doraemonkit.widget.bottomview.BottomUpWindow;
import com.didichuxing.doraemonkit.widget.bottomview.EditSpInputView;

public class SpInputView
extends FrameLayout {
    private OnDataChangeListener onDataChangeListener;
    private static final int FLOAT = 8194;
    private static final int INTEGER = 4098;
    private static final int STRING = 1;
    private TextView spValue;
    private Switch switchBtn;
    private SpBean bean;

    public SpInputView(Context context) {
        super(context, null);
    }

    public SpInputView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SpInputView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        View inflate = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.kd_item_sp_input, (ViewGroup)this, true);
        this.switchBtn = (Switch)inflate.findViewById(R.id.switch_btn);
        this.spValue = (TextView)inflate.findViewById(R.id.tv_sp_value);
    }

    public void setInput(final SpBean bean, final OnDataChangeListener onDataChangeListener) {
        this.bean = bean;
        this.onDataChangeListener = onDataChangeListener;
        switch (bean.value.getClass().getSimpleName()) {
            case "Boolean": {
                this.switchBtn.setChecked(((Boolean)bean.value).booleanValue());
                this.switchBtn.setVisibility(0);
                this.switchBtn.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        bean.value = isChecked;
                        onDataChangeListener.onDataChanged();
                    }
                });
                this.spValue.setVisibility(8);
                break;
            }
            case "Integer": 
            case "Long": {
                this.initEdt(bean, 4098);
                break;
            }
            case "Float": {
                this.initEdt(bean, 8194);
                break;
            }
            case "String": {
                this.initEdt(bean, 1);
                break;
            }
        }
    }

    private void initEdt(final SpBean spBean, final int inputType) {
        this.spValue.setVisibility(0);
        this.switchBtn.setVisibility(8);
        this.spValue.setText((CharSequence)spBean.value.toString());
        this.spValue.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SpInputView.this.showInputView(v, spBean, inputType);
            }
        });
    }

    public void refresh() {
        if (this.bean != null) {
            this.spValue.setText((CharSequence)this.bean.value.toString());
        }
    }

    private void showInputView(View view, final SpBean spBean, int inputType) {
        new BottomUpWindow(this.getContext()).setContent(new EditSpInputView(this.getContext(), spBean, inputType)).show(view).setOnSubmitListener(new BottomUpWindow.OnSubmitListener(){

            @Override
            public void submit(Object object) {
                spBean.value = object;
                if (SpInputView.this.onDataChangeListener != null) {
                    SpInputView.this.onDataChangeListener.onDataChanged();
                }
            }

            @Override
            public void cancel() {
            }
        });
    }

    public static interface OnDataChangeListener {
        public void onDataChanged();
    }
}

