/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.fileexplorer;

import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.SettingItem;
import com.didichuxing.doraemonkit.kit.core.SettingItemAdapter;
import com.didichuxing.doraemonkit.widget.dialog.DialogListener;
import com.didichuxing.doraemonkit.widget.dialog.DialogProvider;
import java.io.File;

public class FileExplorerChooseDialog
extends DialogProvider<File> {
    private RecyclerView mChooseList;
    private SettingItemAdapter mAdapter;
    private OnButtonClickListener onButtonClickListener;

    public FileExplorerChooseDialog(File data, DialogListener listener) {
        super(data, listener);
    }

    @Override
    public int getLayoutId() {
        return R.layout.dk_dialog_file_explorer_choose;
    }

    @Override
    protected void findViews(View view) {
        this.mChooseList = (RecyclerView)view.findViewById(R.id.choose_list);
        this.mAdapter = new SettingItemAdapter(this.getContext());
        this.mChooseList.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mChooseList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
    }

    @Override
    protected void bindData(File file) {
        if (file.isFile()) {
            this.mAdapter.append(new SettingItem(R.string.dk_share));
        }
        this.mAdapter.append(new SettingItem(R.string.dk_delete));
        this.mAdapter.setOnSettingItemClickListener(new SettingItemAdapter.OnSettingItemClickListener(){

            @Override
            public void onSettingItemClick(View view, SettingItem data) {
                if (data.desc == R.string.dk_delete) {
                    if (FileExplorerChooseDialog.this.onButtonClickListener != null) {
                        FileExplorerChooseDialog.this.onButtonClickListener.onDeleteClick(FileExplorerChooseDialog.this);
                    }
                } else if (data.desc == R.string.dk_share && FileExplorerChooseDialog.this.onButtonClickListener != null) {
                    FileExplorerChooseDialog.this.onButtonClickListener.onShareClick(FileExplorerChooseDialog.this);
                }
            }
        });
    }

    public void setOnButtonClickListener(OnButtonClickListener onButtonClickListener) {
        this.onButtonClickListener = onButtonClickListener;
    }

    @Override
    public boolean isCancellable() {
        return true;
    }

    public static interface OnButtonClickListener {
        public void onDeleteClick(FileExplorerChooseDialog var1);

        public void onShareClick(FileExplorerChooseDialog var1);
    }
}

