/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.core;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.StringRes;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.SettingItem;
import com.didichuxing.doraemonkit.kit.health.AppHealthInfoUtil;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsRecyclerAdapter;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsViewBinder;

public class SettingItemAdapter
extends AbsRecyclerAdapter<AbsViewBinder<SettingItem>, SettingItem> {
    private OnSettingItemClickListener mOnSettingItemClickListener;
    private OnSettingItemSwitchListener mOnSettingItemSwitchListener;

    public SettingItemAdapter(Context context) {
        super(context);
    }

    @Override
    protected AbsViewBinder<SettingItem> createViewHolder(View view, int viewType) {
        return new SettingItemViewHolder(view);
    }

    @Override
    protected View createView(LayoutInflater inflater, ViewGroup parent, int viewType) {
        return inflater.inflate(R.layout.dk_item_setting, parent, false);
    }

    private boolean isMatched(@StringRes int desc) {
        int[] resources = new int[]{R.string.dk_weak_network_switch, R.string.dk_item_block_switch, R.string.dk_crash_capture_switch, R.string.dk_cpu_detection_switch, R.string.dk_frameinfo_detection_switch, R.string.dk_ram_detection_switch};
        boolean isMatches = false;
        for (int res : resources) {
            if (res != desc) continue;
            isMatches = true;
            break;
        }
        return isMatches;
    }

    public void setOnSettingItemClickListener(OnSettingItemClickListener onSettingItemClickListener) {
        this.mOnSettingItemClickListener = onSettingItemClickListener;
    }

    public void setOnSettingItemSwitchListener(OnSettingItemSwitchListener onSettingItemSwitchListener) {
        this.mOnSettingItemSwitchListener = onSettingItemSwitchListener;
    }

    public static interface OnSettingItemSwitchListener {
        public void onSettingItemSwitch(View var1, SettingItem var2, boolean var3);
    }

    public static interface OnSettingItemClickListener {
        public void onSettingItemClick(View var1, SettingItem var2);
    }

    public class SettingItemViewHolder
    extends AbsViewBinder<SettingItem> {
        private TextView mDesc;
        private CheckBox mMenuSwitch;
        private ImageView mIcon;
        private TextView mRightDesc;

        public SettingItemViewHolder(View view) {
            super(view);
        }

        @Override
        protected void getViews() {
            this.mMenuSwitch = (CheckBox)this.getView(R.id.menu_switch);
            this.mDesc = (TextView)this.getView(R.id.desc);
            this.mIcon = (ImageView)this.getView(R.id.right_icon);
            this.mRightDesc = (TextView)this.getView(R.id.right_desc);
        }

        @Override
        public void bind(final SettingItem settingItem) {
            this.mDesc.setText(settingItem.desc);
            if (settingItem.canCheck) {
                this.mMenuSwitch.setVisibility(0);
                this.mMenuSwitch.setChecked(settingItem.isChecked);
                this.mMenuSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                        if (SettingItemAdapter.this.isMatched(settingItem.desc) && AppHealthInfoUtil.getInstance().isAppHealthRunning()) {
                            SettingItemViewHolder.this.mMenuSwitch.setChecked(true);
                            return;
                        }
                        settingItem.isChecked = isChecked;
                        SettingItemAdapter.this.mOnSettingItemSwitchListener.onSettingItemSwitch((View)SettingItemViewHolder.this.mMenuSwitch, settingItem, isChecked);
                    }
                });
            }
            if (settingItem.icon != 0) {
                this.mIcon.setVisibility(0);
                this.mIcon.setImageResource(settingItem.icon);
            }
            if (!TextUtils.isEmpty((CharSequence)settingItem.rightDesc)) {
                this.mRightDesc.setVisibility(0);
                this.mRightDesc.setText((CharSequence)settingItem.rightDesc);
            }
        }

        @Override
        protected void onViewClick(View view, SettingItem data) {
            super.onViewClick(view, data);
            if (SettingItemAdapter.this.mOnSettingItemClickListener != null) {
                SettingItemAdapter.this.mOnSettingItemClickListener.onSettingItemClick(view, data);
            }
        }
    }
}

