/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.blockmonitor.core;

import android.os.SystemClock;
import android.util.Printer;
import com.didichuxing.doraemonkit.kit.blockmonitor.bean.BlockInfo;
import com.didichuxing.doraemonkit.kit.blockmonitor.core.BlockMonitorManager;
import com.didichuxing.doraemonkit.kit.blockmonitor.core.StackSampler;
import java.util.ArrayList;

class MonitorCore
implements Printer {
    private static final String TAG = "MonitorCore";
    private static final int BLOCK_THRESHOLD_MILLIS = 200;
    private long mStartTime = 0L;
    private long mStartThreadTime = 0L;
    private boolean mPrintingStarted = false;
    private StackSampler mStackSampler = new StackSampler();

    public MonitorCore() {
        this.mStackSampler.init();
    }

    public void println(String x) {
        if (!this.mPrintingStarted) {
            this.mStartTime = System.currentTimeMillis();
            this.mStartThreadTime = SystemClock.currentThreadTimeMillis();
            this.mPrintingStarted = true;
            this.mStackSampler.startDump();
        } else {
            ArrayList<String> entries;
            long endTime = System.currentTimeMillis();
            long endThreadTime = SystemClock.currentThreadTimeMillis();
            this.mPrintingStarted = false;
            if (this.isBlock(endTime) && (entries = this.mStackSampler.getThreadStackEntries(this.mStartTime, endTime)).size() > 0) {
                BlockInfo blockInfo = BlockInfo.newInstance().setMainThreadTimeCost(this.mStartTime, endTime, this.mStartThreadTime, endThreadTime).setThreadStackEntries(entries).flushString();
                BlockMonitorManager.getInstance().notifyBlockEvent(blockInfo);
            }
            this.mStackSampler.stopDump();
        }
    }

    private boolean isBlock(long endTime) {
        return endTime - this.mStartTime > 200L;
    }

    public void shutDown() {
        this.mStackSampler.shutDown();
    }
}

