/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.aop.bigimg.coil;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import coil.bitmap.BitmapPool;
import coil.size.Size;
import coil.transform.Transformation;
import com.didichuxing.doraemonkit.config.PerformanceSpInfoConfig;
import com.didichuxing.doraemonkit.kit.largepicture.LargePictureManager;
import com.didichuxing.doraemonkit.util.ConvertUtils;
import kotlin.coroutines.Continuation;

public class DokitCoilTransformation
implements Transformation {
    private static final String TAG = "DokitTransformation";
    private Object mUri;

    public DokitCoilTransformation(Object uri) {
        this.mUri = uri;
    }

    public String key() {
        return "Dokit&Coil&LargeBitmapTransformation";
    }

    @Nullable
    public Object transform(@NonNull BitmapPool bitmapPool, @NonNull Bitmap source, @NonNull Size size, @NonNull Continuation<? super Bitmap> continuation) {
        try {
            if (PerformanceSpInfoConfig.isLargeImgOpen()) {
                double imgSize = ConvertUtils.byte2MemorySize((long)source.getByteCount(), (int)0x100000);
                if (this.mUri != null) {
                    LargePictureManager.getInstance().saveImageInfo(this.mUri.toString(), imgSize, source.getWidth(), source.getHeight(), "Coil");
                } else {
                    LargePictureManager.getInstance().saveImageInfo("Null Uri", imgSize, source.getWidth(), source.getHeight(), "Coil");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return source;
    }
}

