/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TouchUtils {
    public static final int UNKNOWN = 0;
    public static final int LEFT = 1;
    public static final int UP = 2;
    public static final int RIGHT = 4;
    public static final int DOWN = 8;

    private TouchUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void setOnTouchListener(View v, OnTouchUtilsListener listener) {
        if (v == null || listener == null) {
            return;
        }
        v.setOnTouchListener((View.OnTouchListener)listener);
    }

    public static abstract class OnTouchUtilsListener
    implements View.OnTouchListener {
        private static final int STATE_DOWN = 0;
        private static final int STATE_MOVE = 1;
        private static final int STATE_STOP = 2;
        private static final int MIN_TAP_TIME = 1000;
        private int touchSlop;
        private int downX;
        private int downY;
        private int lastX;
        private int lastY;
        private int state;
        private int direction;
        private VelocityTracker velocityTracker;
        private int maximumFlingVelocity;
        private int minimumFlingVelocity;

        public OnTouchUtilsListener() {
            this.resetTouch(-1, -1);
        }

        private void resetTouch(int x, int y) {
            this.downX = x;
            this.downY = y;
            this.lastX = x;
            this.lastY = y;
            this.state = 0;
            this.direction = 0;
            if (this.velocityTracker != null) {
                this.velocityTracker.clear();
            }
        }

        public abstract boolean onDown(View var1, int var2, int var3, MotionEvent var4);

        public abstract boolean onMove(View var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, MotionEvent var9);

        public abstract boolean onStop(View var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, MotionEvent var9);

        public boolean onTouch(View v, MotionEvent event) {
            if (this.touchSlop == 0) {
                this.touchSlop = ViewConfiguration.get((Context)v.getContext()).getScaledTouchSlop();
            }
            if (this.maximumFlingVelocity == 0) {
                this.maximumFlingVelocity = ViewConfiguration.get((Context)v.getContext()).getScaledMaximumFlingVelocity();
            }
            if (this.minimumFlingVelocity == 0) {
                this.minimumFlingVelocity = ViewConfiguration.get((Context)v.getContext()).getScaledMinimumFlingVelocity();
            }
            if (this.velocityTracker == null) {
                this.velocityTracker = VelocityTracker.obtain();
            }
            this.velocityTracker.addMovement(event);
            switch (event.getAction()) {
                case 0: {
                    return this.onUtilsDown(v, event);
                }
                case 2: {
                    return this.onUtilsMove(v, event);
                }
                case 1: 
                case 3: {
                    return this.onUtilsStop(v, event);
                }
            }
            return false;
        }

        public boolean onUtilsDown(View view, MotionEvent event) {
            int x = (int)event.getRawX();
            int y = (int)event.getRawY();
            this.resetTouch(x, y);
            view.setPressed(true);
            return this.onDown(view, x, y, event);
        }

        public boolean onUtilsMove(View view, MotionEvent event) {
            int x = (int)event.getRawX();
            int y = (int)event.getRawY();
            if (this.downX == -1) {
                this.resetTouch(x, y);
                view.setPressed(true);
            }
            if (this.state != 1) {
                if (Math.abs(x - this.lastX) < this.touchSlop && Math.abs(y - this.lastY) < this.touchSlop) {
                    return true;
                }
                this.state = 1;
                this.direction = Math.abs(x - this.lastX) >= Math.abs(y - this.lastY) ? (x - this.lastX < 0 ? 1 : 4) : (y - this.lastY < 0 ? 2 : 8);
            }
            boolean consumeMove = this.onMove(view, this.direction, x, y, x - this.lastX, y - this.lastY, x - this.downX, y - this.downY, event);
            this.lastX = x;
            this.lastY = y;
            return consumeMove;
        }

        public boolean onUtilsStop(View view, MotionEvent event) {
            int x = (int)event.getRawX();
            int y = (int)event.getRawY();
            int vx = 0;
            int vy = 0;
            if (this.velocityTracker != null) {
                this.velocityTracker.computeCurrentVelocity(1000, (float)this.maximumFlingVelocity);
                vx = (int)this.velocityTracker.getXVelocity();
                vy = (int)this.velocityTracker.getYVelocity();
                this.velocityTracker.recycle();
                if (Math.abs(vx) < this.minimumFlingVelocity) {
                    vx = 0;
                }
                if (Math.abs(vy) < this.minimumFlingVelocity) {
                    vy = 0;
                }
                this.velocityTracker = null;
            }
            view.setPressed(false);
            boolean consumeStop = this.onStop(view, this.direction, x, y, x - this.downX, y - this.downY, vx, vy, event);
            if (event.getAction() == 1 && this.state == 0) {
                if (event.getEventTime() - event.getDownTime() <= 1000L) {
                    view.performClick();
                } else {
                    view.performLongClick();
                }
            }
            this.resetTouch(-1, -1);
            return consumeStop;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }
}

