/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.annotation.SuppressLint;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.didichuxing.doraemonkit.util.Utils;
import com.didichuxing.doraemonkit.util.UtilsBridge;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class PhoneUtils {
    private PhoneUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isPhone() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getPhoneType() != 0;
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getDeviceId() {
        if (Build.VERSION.SDK_INT >= 29) {
            return "";
        }
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        String deviceId = tm.getDeviceId();
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            return deviceId;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            String imei = tm.getImei();
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                return imei;
            }
            String meid = tm.getMeid();
            return TextUtils.isEmpty((CharSequence)meid) ? "" : meid;
        }
        return "";
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getSerial() {
        if (Build.VERSION.SDK_INT >= 29) {
            try {
                return Build.getSerial();
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return "";
            }
        }
        return Build.VERSION.SDK_INT >= 26 ? Build.getSerial() : Build.SERIAL;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMEI() {
        return PhoneUtils.getImeiOrMeid(true);
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getMEID() {
        return PhoneUtils.getImeiOrMeid(false);
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getImeiOrMeid(boolean isImei) {
        if (Build.VERSION.SDK_INT >= 29) {
            return "";
        }
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        if (Build.VERSION.SDK_INT >= 26) {
            if (isImei) {
                return PhoneUtils.getMinOne(tm.getImei(0), tm.getImei(1));
            }
            return PhoneUtils.getMinOne(tm.getMeid(0), tm.getMeid(1));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            String ids = PhoneUtils.getSystemPropertyByReflect(isImei ? "ril.gsm.imei" : "ril.cdma.meid");
            if (!TextUtils.isEmpty((CharSequence)ids)) {
                String[] idArr = ids.split(",");
                if (idArr.length == 2) {
                    return PhoneUtils.getMinOne(idArr[0], idArr[1]);
                }
                return idArr[0];
            }
            String id0 = tm.getDeviceId();
            String id1 = "";
            try {
                Method method = tm.getClass().getMethod("getDeviceId", Integer.TYPE);
                id1 = (String)method.invoke((Object)tm, isImei ? 1 : 2);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (isImei) {
                if (id0 != null && id0.length() < 15) {
                    id0 = "";
                }
                if (id1 != null && id1.length() < 15) {
                    id1 = "";
                }
            } else {
                if (id0 != null && id0.length() == 14) {
                    id0 = "";
                }
                if (id1 != null && id1.length() == 14) {
                    id1 = "";
                }
            }
            return PhoneUtils.getMinOne(id0, id1);
        }
        String deviceId = tm.getDeviceId();
        if (isImei ? deviceId != null && deviceId.length() >= 15 : deviceId != null && deviceId.length() == 14) {
            return deviceId;
        }
        return "";
    }

    private static String getMinOne(String s0, String s1) {
        boolean empty0 = TextUtils.isEmpty((CharSequence)s0);
        boolean empty1 = TextUtils.isEmpty((CharSequence)s1);
        if (empty0 && empty1) {
            return "";
        }
        if (!empty0 && !empty1) {
            if (s0.compareTo(s1) <= 0) {
                return s0;
            }
            return s1;
        }
        if (!empty0) {
            return s0;
        }
        return s1;
    }

    private static String getSystemPropertyByReflect(String key) {
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method getMethod = clz.getMethod("get", String.class, String.class);
            return (String)getMethod.invoke(clz, key, "");
        }
        catch (Exception exception) {
            return "";
        }
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMSI() {
        if (Build.VERSION.SDK_INT >= 29) {
            try {
                PhoneUtils.getTelephonyManager().getSubscriberId();
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return "";
            }
        }
        return PhoneUtils.getTelephonyManager().getSubscriberId();
    }

    public static int getPhoneType() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getPhoneType();
    }

    public static boolean isSimCardReady() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getSimState() == 5;
    }

    public static String getSimOperatorName() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getSimOperatorName();
    }

    public static String getSimOperatorByMnc() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        String operator = tm.getSimOperator();
        if (operator == null) {
            return "";
        }
        switch (operator) {
            case "46000": 
            case "46002": 
            case "46007": 
            case "46020": {
                return "\u4e2d\u56fd\u79fb\u52a8";
            }
            case "46001": 
            case "46006": 
            case "46009": {
                return "\u4e2d\u56fd\u8054\u901a";
            }
            case "46003": 
            case "46005": 
            case "46011": {
                return "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        return operator;
    }

    public static void dial(@NonNull String phoneNumber) {
        Utils.getApp().startActivity(UtilsBridge.getDialIntent(phoneNumber));
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public static void call(@NonNull String phoneNumber) {
        Utils.getApp().startActivity(UtilsBridge.getCallIntent(phoneNumber));
    }

    public static void sendSms(@NonNull String phoneNumber, String content) {
        Utils.getApp().startActivity(UtilsBridge.getSendSmsIntent(phoneNumber, content));
    }

    private static TelephonyManager getTelephonyManager() {
        return (TelephonyManager)Utils.getApp().getSystemService("phone");
    }
}

