/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import com.didichuxing.doraemonkit.util.ThreadUtils;
import com.didichuxing.doraemonkit.util.UtilsBridge;

public final class Utils {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Application sApp;

    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void init(Application app) {
        if (app == null) {
            Log.e((String)"Utils", (String)"app is null.");
            return;
        }
        if (sApp == null) {
            sApp = app;
            UtilsBridge.init(sApp);
            UtilsBridge.preLoad();
            return;
        }
        if (sApp.equals(app)) {
            return;
        }
        UtilsBridge.unInit(sApp);
        sApp = app;
        UtilsBridge.init(sApp);
    }

    public static Application getApp() {
        if (sApp != null) {
            return sApp;
        }
        Utils.init(UtilsBridge.getApplicationByReflect());
        if (sApp == null) {
            throw new NullPointerException("reflect failed.");
        }
        Log.i((String)"Utils", (String)(UtilsBridge.getCurrentProcessName() + " reflect app success."));
        return sApp;
    }

    public static interface Func1<Ret, Par> {
        public Ret call(Par var1);
    }

    public static interface Supplier<T> {
        public T get();
    }

    public static interface Consumer<T> {
        public void accept(T var1);
    }

    public static class ActivityLifecycleCallbacks {
        public void onActivityCreated(@NonNull Activity activity) {
        }

        public void onActivityStarted(@NonNull Activity activity) {
        }

        public void onActivityResumed(@NonNull Activity activity) {
        }

        public void onActivityPaused(@NonNull Activity activity) {
        }

        public void onActivityStopped(@NonNull Activity activity) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
        }

        public void onLifecycleChanged(@NonNull Activity activity, Lifecycle.Event event) {
        }
    }

    public static interface OnAppStatusChangedListener {
        public void onForeground(Activity var1);

        public void onBackground(Activity var1);
    }

    public static abstract class Task<Result>
    extends ThreadUtils.SimpleTask<Result> {
        private Consumer<Result> mConsumer;

        public Task(Consumer<Result> consumer) {
            this.mConsumer = consumer;
        }

        @Override
        public void onSuccess(Result result) {
            if (this.mConsumer != null) {
                this.mConsumer.accept(result);
            }
        }
    }
}

