/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.util.Pair;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class MapUtils {
    private MapUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newUnmodifiableMap(Pair<K, V> ... pairs) {
        return Collections.unmodifiableMap(MapUtils.newHashMap(pairs));
    }

    @SafeVarargs
    public static <K, V> HashMap<K, V> newHashMap(Pair<K, V> ... pairs) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (pairs == null || pairs.length == 0) {
            return map;
        }
        for (Pair<K, V> pair : pairs) {
            if (pair == null) continue;
            map.put(pair.first, pair.second);
        }
        return map;
    }

    @SafeVarargs
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Pair<K, V> ... pairs) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        if (pairs == null || pairs.length == 0) {
            return map;
        }
        for (Pair<K, V> pair : pairs) {
            if (pair == null) continue;
            map.put(pair.first, pair.second);
        }
        return map;
    }

    @SafeVarargs
    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<K> comparator, Pair<K, V> ... pairs) {
        if (comparator == null) {
            throw new IllegalArgumentException("comparator must not be null");
        }
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(comparator);
        if (pairs == null || pairs.length == 0) {
            return map;
        }
        for (Pair<K, V> pair : pairs) {
            if (pair == null) continue;
            map.put(pair.first, pair.second);
        }
        return map;
    }

    @SafeVarargs
    public static <K, V> Hashtable<K, V> newHashTable(Pair<K, V> ... pairs) {
        Hashtable<Object, Object> map = new Hashtable<Object, Object>();
        if (pairs == null || pairs.length == 0) {
            return map;
        }
        for (Pair<K, V> pair : pairs) {
            if (pair == null) continue;
            map.put(pair.first, pair.second);
        }
        return map;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.size() == 0;
    }

    public static boolean isNotEmpty(Map map) {
        return !MapUtils.isEmpty(map);
    }

    public static int size(Map map) {
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public static <K, V> void forAllDo(Map<K, V> map, Closure<K, V> closure) {
        if (map == null || closure == null) {
            return;
        }
        for (Map.Entry<K, V> kvEntry : map.entrySet()) {
            closure.execute(kvEntry.getKey(), kvEntry.getValue());
        }
    }

    public static <K1, V1, K2, V2> Map<K2, V2> transform(Map<K1, V1> map, final Transformer<K1, V1, K2, V2> transformer) {
        if (map == null || transformer == null) {
            return null;
        }
        try {
            final Map transMap = (Map)map.getClass().newInstance();
            MapUtils.forAllDo(map, new Closure<K1, V1>(){

                @Override
                public void execute(K1 key, V1 value) {
                    Pair pair = transformer.transform(key, value);
                    transMap.put(pair.first, pair.second);
                }
            });
            return transMap;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String toString(Map map) {
        if (map == null) {
            return "null";
        }
        return map.toString();
    }

    public static interface Transformer<K1, V1, K2, V2> {
        public Pair<K2, V2> transform(K1 var1, V1 var2);
    }

    public static interface Closure<K, V> {
        public void execute(K var1, V var2);
    }
}

