/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Scanner;

public final class HttpsUtil {
    private static final int CONNECT_TIMEOUT_TIME = 15000;
    private static final int READ_TIMEOUT_TIME = 19000;

    public static String postJson(String data, String url) {
        return HttpsUtil.doHttpAction(data, true, true, url);
    }

    public static String postForm(String data, String url) {
        return HttpsUtil.doHttpAction(data, false, true, url);
    }

    public static String getJson(String data, String url) {
        return HttpsUtil.doHttpAction(data, true, false, url);
    }

    public static String getForm(String data, String url) {
        return HttpsUtil.doHttpAction(data, false, false, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doHttpAction(String data, boolean json, boolean post, String url) {
        HttpURLConnection connection = null;
        FilterOutputStream os = null;
        InputStream is = null;
        try {
            URL sUrl = new URL(url);
            connection = (HttpURLConnection)sUrl.openConnection();
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(19000);
            if (post) {
                connection.setRequestMethod("POST");
            } else {
                connection.setRequestMethod("GET");
            }
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            if (json) {
                connection.setRequestProperty("Content-Type", "application/json");
            } else {
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", data.length() + "");
            }
            connection.connect();
            os = new DataOutputStream(connection.getOutputStream());
            ((DataOutputStream)os).write(data.getBytes(), 0, data.getBytes().length);
            ((DataOutputStream)os).flush();
            os.close();
            is = connection.getInputStream();
            Scanner scan = new Scanner(is);
            scan.useDelimiter("\\A");
            if (scan.hasNext()) {
                String string = scan.next();
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

