/*
 * Decompiled with CFR 0.152.
 */
package io.github.dft.amazon.fulfillmentinbound;

import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import io.github.dft.amazon.AmazonSellingPartnerSdk;
import io.github.dft.amazon.fulfillmentinbound.model.GetShipmentItemsResponse;
import io.github.dft.amazon.fulfillmentinbound.model.GetShipmentsResponse;
import io.github.dft.amazon.fulfillmentinbound.model.GetShipmentsResult;
import io.github.dft.amazon.fulfillmentinbound.model.InboundShipmentInfo;
import io.github.dft.amazon.fulfillmentinbound.model.InboundShipmentList;
import io.github.dft.amazon.model.AmazonCredentials;
import io.github.dft.amazon.model.handler.JsonBodyHandler;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FulfillmentInbound
extends AmazonSellingPartnerSdk {
    public FulfillmentInbound(AmazonCredentials amazonCredentials) {
        super(amazonCredentials);
    }

    public GetShipmentsResponse getShipments(HashMap<String, String> query) {
        DefaultRequest<Object> signRequest = this.signRequest("/fba/inbound/v0/shipments", HttpMethodName.GET, query);
        URI uri = new URI(this.sellingRegionEndpoint + "/fba/inbound/v0/shipments");
        uri = this.addParameters(uri, query);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).build();
        JsonBodyHandler<GetShipmentsResponse> handler = new JsonBodyHandler<GetShipmentsResponse>(GetShipmentsResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetShipmentItemsResponse getShipmentItemsByShipmentId(String shipmentId) {
        String url = String.format("/fba/inbound/v0/shipments/%s/items", shipmentId);
        DefaultRequest<Object> signRequest = this.signRequest(url, HttpMethodName.GET, null);
        URI uri = new URI(this.sellingRegionEndpoint + url);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).build();
        JsonBodyHandler<GetShipmentItemsResponse> handler = new JsonBodyHandler<GetShipmentItemsResponse>(GetShipmentItemsResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public List<InboundShipmentInfo> getAllShipmentsByStatuses(String statuses) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("ShipmentStatusList", statuses);
        query.put("QueryType", "SHIPMENT");
        GetShipmentsResponse getShipmentsResponse = this.getShipments(query);
        GetShipmentsResult getShipmentsResult = getShipmentsResponse.getPayload();
        InboundShipmentList<InboundShipmentInfo> inboundShipmentList = getShipmentsResult.getShipmentData();
        ArrayList<InboundShipmentInfo> inboundShipmentInfoList = new ArrayList<InboundShipmentInfo>(inboundShipmentList);
        while (getShipmentsResult.getNextToken() != null) {
            query = new HashMap();
            query.put("NextToken", getShipmentsResult.getNextToken());
            query.put("QueryType", "NEXT_TOKEN");
            getShipmentsResponse = this.getShipments(query);
            getShipmentsResult = getShipmentsResponse.getPayload();
            inboundShipmentList = getShipmentsResult.getShipmentData();
            inboundShipmentInfoList.addAll(inboundShipmentList);
        }
        return inboundShipmentInfoList;
    }
}

