/*
 * Decompiled with CFR 0.152.
 */
package io.github.dft.amazon;

import com.amazonaws.DefaultRequest;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.dft.amazon.model.AmazonCredentials;
import io.github.dft.amazon.model.auth.AccessTokenResponse;
import io.github.dft.amazon.model.handler.JsonBodyHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.http.client.utils.URIBuilder;

public class AmazonSellingPartnerSdk {
    protected AmazonCredentials amazonCredentials;
    protected String sellingRegionEndpoint;
    protected HttpClient client;
    private ObjectMapper objectMapper;

    public AmazonSellingPartnerSdk() {
        this.client = HttpClient.newHttpClient();
    }

    public AmazonSellingPartnerSdk(AmazonCredentials amazonCredentials) {
        this.amazonCredentials = amazonCredentials;
        this.sellingRegionEndpoint = "eu-west-1".equalsIgnoreCase(amazonCredentials.getRegion()) ? "https://sellingpartnerapi-eu.amazon.com" : ("us-east-1".equalsIgnoreCase(amazonCredentials.getRegion()) ? "https://sellingpartnerapi-na.amazon.com" : ("us-west-2".equalsIgnoreCase(amazonCredentials.getRegion()) ? "https://sellingpartnerapi-fe.amazon.com" : null));
        this.objectMapper = new ObjectMapper();
        this.client = HttpClient.newHttpClient();
    }

    protected DefaultRequest<Object> signRequest(String resourcePath, HttpMethodName httpMethodName, Map<String, String> params) {
        return this.signRequest(resourcePath, httpMethodName, params, null);
    }

    protected DefaultRequest<Object> signRequest(String resourcePath, HttpMethodName httpMethodName, Map<String, String> params, String payload) {
        this.refreshAccessToken();
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(this.amazonCredentials.getAccessKeyId(), this.amazonCredentials.getSecretAccessKey());
        STSAssumeRoleSessionCredentialsProvider credentialsProvider = new STSAssumeRoleSessionCredentialsProvider.Builder(this.amazonCredentials.getRoleArn(), "rakesh").withStsClient((AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(this.amazonCredentials.getRegion())).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials))).build()).build();
        AWS4Signer signer = new AWS4Signer();
        signer.setRegionName(this.amazonCredentials.getRegion());
        signer.setServiceName("execute-api");
        DefaultRequest request = new DefaultRequest("execute-api");
        request.setEndpoint(URI.create(this.sellingRegionEndpoint));
        if (!resourcePath.isBlank()) {
            request.setResourcePath(resourcePath);
        }
        if (params != null) {
            params.forEach((arg_0, arg_1) -> ((DefaultRequest)request).addParameter(arg_0, arg_1));
        }
        request.setHttpMethod(httpMethodName);
        if (null != payload) {
            request.setContent((InputStream)new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8)));
        }
        signer.sign((SignableRequest)request, (AWSCredentials)credentialsProvider.getCredentials());
        return request;
    }

    protected void refreshAccessToken() {
        if (this.amazonCredentials.getAccessToken() == null || this.amazonCredentials.getExpiresInTime() == null || ZonedDateTime.now(ZoneOffset.UTC).isAfter(this.amazonCredentials.getExpiresInTime())) {
            HashMap<Object, Object> data = new HashMap<Object, Object>();
            data.put("grant_type", "refresh_token");
            data.put("refresh_token", this.amazonCredentials.getRefreshToken());
            data.put("client_id", this.amazonCredentials.getClientIdentifier());
            data.put("client_secret", this.amazonCredentials.getClientSecret());
            HttpRequest request = HttpRequest.newBuilder(new URI("https://api.amazon.com/auth/o2/token")).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").POST(this.ofFormData(data)).build();
            AccessTokenResponse accessTokenResponse = HttpClient.newHttpClient().send(request, new JsonBodyHandler<AccessTokenResponse>(AccessTokenResponse.class)).body();
            this.amazonCredentials.setAccessToken(accessTokenResponse.getAccessToken());
            this.amazonCredentials.setRefreshToken(accessTokenResponse.getRefreshToken());
            this.amazonCredentials.setExpiresInTime(ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(accessTokenResponse.getExpiresIn()));
            this.amazonCredentials.setTokenType(accessTokenResponse.getTokenType());
        }
    }

    public HttpRequest.BodyPublisher ofFormData(Map<Object, Object> data) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(URLEncoder.encode(entry.getKey().toString(), StandardCharsets.UTF_8));
            builder.append("=");
            builder.append(URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8));
        }
        return HttpRequest.BodyPublishers.ofString(builder.toString());
    }

    protected String getString(Object body) {
        return this.objectMapper.writeValueAsString(body);
    }

    protected void addParameters(URIBuilder uriBuilder, HashMap<String, String> params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        for (String key : params.keySet()) {
            uriBuilder.addParameter(key, params.get(key));
        }
    }

    protected URI addParameters(URI uri, HashMap<String, String> params) {
        String query = uri.getQuery();
        StringBuilder builder = new StringBuilder();
        if (query != null) {
            builder.append(query);
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String keyValueParam = entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8);
            if (!builder.toString().isEmpty()) {
                builder.append("&");
            }
            builder.append(keyValueParam);
        }
        return URI.create(uri.getScheme() + "://" + uri.getAuthority() + uri.getPath() + "?" + builder);
    }

    public <T> T getRequestWrapped(HttpRequest request, HttpResponse.BodyHandler<T> handler) {
        return ((HttpResponse)((CompletableFuture)this.client.sendAsync(request, handler).thenComposeAsync(response -> this.tryResend(this.client, request, handler, (HttpResponse)response, 1))).get()).body();
    }

    public <T> CompletableFuture<HttpResponse<T>> tryResend(HttpClient client, HttpRequest request, HttpResponse.BodyHandler<T> handler, HttpResponse<T> resp, int count) {
        if (resp.statusCode() == 429 && count < 50) {
            Thread.sleep(15000L);
            return client.sendAsync(request, handler).thenComposeAsync(response -> this.tryResend(client, request, handler, (HttpResponse)response, count + 1));
        }
        return CompletableFuture.completedFuture(resp);
    }
}

