/*
 * Decompiled with CFR 0.152.
 */
package io.github.dft.amazon;

import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import io.github.dft.amazon.AmazonSellingPartnerSdk;
import io.github.dft.amazon.model.AmazonCredentials;
import io.github.dft.amazon.model.handler.JsonBodyHandler;
import io.github.dft.amazon.model.reports.v202106.CancelResponse;
import io.github.dft.amazon.model.reports.v202106.CreateReportResponse;
import io.github.dft.amazon.model.reports.v202106.CreateReportScheduleResponse;
import io.github.dft.amazon.model.reports.v202106.CreateReportScheduleSpecification;
import io.github.dft.amazon.model.reports.v202106.CreateReportSpecification;
import io.github.dft.amazon.model.reports.v202106.GetReportsResponse;
import io.github.dft.amazon.model.reports.v202106.Report;
import io.github.dft.amazon.model.reports.v202106.ReportDocument;
import io.github.dft.amazon.model.reports.v202106.ReportSchedule;
import io.github.dft.amazon.model.reports.v202106.ReportScheduleList;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class AmazonSPReports
extends AmazonSellingPartnerSdk {
    public AmazonSPReports(AmazonCredentials amazonCredentials) {
        super(amazonCredentials);
    }

    public CreateReportResponse createReport(CreateReportSpecification createReportSpecification) {
        String requestBody = this.getString(createReportSpecification);
        DefaultRequest<Object> signRequest = this.signRequest("/reports/2021-06-30/reports", HttpMethodName.POST, null, requestBody);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/reports/2021-06-30/reports")).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        JsonBodyHandler<CreateReportResponse> handler = new JsonBodyHandler<CreateReportResponse>(CreateReportResponse.class);
        return (CreateReportResponse)((HttpResponse)((CompletableFuture)this.client.sendAsync(request, handler).thenComposeAsync(response -> this.tryResend(this.client, request, handler, response, 1))).get()).body();
    }

    public Report getReport(String reportId) {
        DefaultRequest<Object> signRequest = this.signRequest("/reports/2021-06-30/reports".concat("/").concat(reportId), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/reports/2021-06-30/reports".concat("/").concat(reportId))).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<Report> handler = new JsonBodyHandler<Report>(Report.class);
        return (Report)((HttpResponse)((CompletableFuture)this.client.sendAsync(request, handler).thenComposeAsync(response -> this.tryResend(this.client, request, handler, response, 1))).get()).body();
    }

    public ReportDocument getReportDocument(String reportDocumentId) {
        reportDocumentId = StringUtils.isEmpty((CharSequence)reportDocumentId) ? "" : reportDocumentId;
        DefaultRequest<Object> signRequest = this.signRequest("/reports/2021-06-30/documents".concat("/").concat(reportDocumentId), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/reports/2021-06-30/documents".concat("/").concat(reportDocumentId))).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<ReportDocument> handler = new JsonBodyHandler<ReportDocument>(ReportDocument.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetReportsResponse getReports(HashMap<String, String> params) {
        DefaultRequest<Object> signRequest = this.signRequest("/reports/2021-06-30/reports", HttpMethodName.GET, params, null);
        URIBuilder uriBuilder = new URIBuilder(this.sellingRegionEndpoint + "/reports/2021-06-30/reports");
        if (params != null && !params.isEmpty()) {
            for (String key : params.keySet()) {
                uriBuilder.addParameter(key, params.get(key));
            }
        }
        URI uri = uriBuilder.build();
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<GetReportsResponse> handler = new JsonBodyHandler<GetReportsResponse>(GetReportsResponse.class);
        return (GetReportsResponse)((HttpResponse)((CompletableFuture)this.client.sendAsync(request, handler).thenComposeAsync(response -> this.tryResend(this.client, request, handler, response, 1))).get()).body();
    }

    public CancelResponse cancelReport(String reportId) {
        reportId = StringUtils.isEmpty((CharSequence)reportId) ? "" : reportId;
        DefaultRequest<Object> signRequest = this.signRequest("/reports/2021-06-30/reports".concat("/").concat(reportId), HttpMethodName.DELETE, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/reports/2021-06-30/reports".concat("/").concat(reportId))).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).DELETE().build();
        JsonBodyHandler<CancelResponse> handler = new JsonBodyHandler<CancelResponse>(CancelResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public CreateReportScheduleResponse createReportSchedule(CreateReportScheduleSpecification createReportScheduleSpecification) {
        String requestBody = this.getString(createReportScheduleSpecification);
        DefaultRequest<Object> signRequest = this.signRequest("/reports/2021-06-30/schedules", HttpMethodName.POST, null, requestBody);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/reports/2021-06-30/schedules")).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        JsonBodyHandler<CreateReportScheduleResponse> handler = new JsonBodyHandler<CreateReportScheduleResponse>(CreateReportScheduleResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public ReportSchedule getReportSchedule(String reportScheduleId) {
        reportScheduleId = StringUtils.isEmpty((CharSequence)reportScheduleId) ? "" : reportScheduleId;
        DefaultRequest<Object> signRequest = this.signRequest("/reports/2021-06-30/schedules".concat("/").concat(reportScheduleId), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/reports/2021-06-30/schedules".concat("/").concat(reportScheduleId))).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).build();
        JsonBodyHandler<ReportSchedule> handler = new JsonBodyHandler<ReportSchedule>(ReportSchedule.class);
        return this.getRequestWrapped(request, handler);
    }

    public ReportScheduleList getReportSchedules(HashMap<String, String> params) {
        DefaultRequest<Object> signRequest = this.signRequest("/reports/2021-06-30/schedules", HttpMethodName.GET, params, null);
        URIBuilder uriBuilder = new URIBuilder(this.sellingRegionEndpoint + "/reports/2021-06-30/schedules");
        if (params != null && !params.isEmpty()) {
            for (String key : params.keySet()) {
                uriBuilder.addParameter(key, params.get(key));
            }
        }
        URI uri = uriBuilder.build();
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).build();
        JsonBodyHandler<ReportScheduleList> handler = new JsonBodyHandler<ReportScheduleList>(ReportScheduleList.class);
        return this.getRequestWrapped(request, handler);
    }

    public CancelResponse cancelReportSchedule(String reportScheduleId) {
        reportScheduleId = StringUtils.isEmpty((CharSequence)reportScheduleId) ? "" : reportScheduleId;
        DefaultRequest<Object> signRequest = this.signRequest("/reports/2021-06-30/schedules".concat("/").concat(reportScheduleId), HttpMethodName.DELETE, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/reports/2021-06-30/schedules".concat("/").concat(reportScheduleId))).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).DELETE().build();
        JsonBodyHandler<CancelResponse> handler = new JsonBodyHandler<CancelResponse>(CancelResponse.class);
        return this.getRequestWrapped(request, handler);
    }
}

