/*
 * Decompiled with CFR 0.152.
 */
package io.github.dft.amazon;

import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import io.github.dft.amazon.AmazonSellingPartnerSdk;
import io.github.dft.amazon.model.AmazonCredentials;
import io.github.dft.amazon.model.handler.JsonBodyHandler;
import io.github.dft.amazon.model.productprice.GetCompetitivePriceResponse;
import io.github.dft.amazon.model.productprice.batch.BatchOffersRequest;
import io.github.dft.amazon.model.productprice.batch.GetListingOffersBatchResponse;
import io.github.dft.amazon.model.productprice.listinganditemoffer.GetOffersResponse;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.HashMap;
import org.apache.http.client.utils.URIBuilder;

public class AmazonSPProductPricing
extends AmazonSellingPartnerSdk {
    public AmazonSPProductPricing(AmazonCredentials amazonCredentials) {
        super(amazonCredentials);
    }

    public GetCompetitivePriceResponse getCompetitivePricing(HashMap<String, String> params) {
        DefaultRequest<Object> signRequest = this.signRequest("/products/pricing/v0/competitivePrice", HttpMethodName.GET, params, null);
        URIBuilder uriBuilder = new URIBuilder(this.sellingRegionEndpoint + "/products/pricing/v0/competitivePrice");
        this.addParameters(uriBuilder, params);
        URI uri = uriBuilder.build();
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<GetCompetitivePriceResponse> handler = new JsonBodyHandler<GetCompetitivePriceResponse>(GetCompetitivePriceResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetOffersResponse getListingOffersBySku(String sellerSku, HashMap<String, String> params) {
        URI uri = URI.create(this.sellingRegionEndpoint + "/products/pricing/v0/listings/" + sellerSku + "/offers");
        uri = this.addParameters(uri, params);
        DefaultRequest<Object> signRequest = this.signRequest(String.valueOf(uri), HttpMethodName.GET, params, null);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<GetOffersResponse> handler = new JsonBodyHandler<GetOffersResponse>(GetOffersResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetOffersResponse getItemOfferByAsin(String asin, HashMap<String, String> params) {
        URI uri = URI.create(this.sellingRegionEndpoint + "/products/pricing/v0/items/" + asin + "/offers");
        uri = this.addParameters(uri, params);
        DefaultRequest<Object> signRequest = this.signRequest(String.valueOf(uri), HttpMethodName.GET, params, null);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<GetOffersResponse> handler = new JsonBodyHandler<GetOffersResponse>(GetOffersResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetListingOffersBatchResponse getItemOffersBatch(BatchOffersRequest batchOffersRequest) {
        URI uri = URI.create(this.sellingRegionEndpoint + "/batches/products/pricing/v0/itemOffers");
        DefaultRequest<Object> signRequest = this.signRequest(String.valueOf(uri), HttpMethodName.POST, null);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).POST(HttpRequest.BodyPublishers.ofString(this.getString(batchOffersRequest))).build();
        JsonBodyHandler<GetListingOffersBatchResponse> handler = new JsonBodyHandler<GetListingOffersBatchResponse>(GetListingOffersBatchResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetListingOffersBatchResponse getListingOffersBatch(BatchOffersRequest batchOffersRequest) {
        URI uri = URI.create(this.sellingRegionEndpoint + "/batches/products/pricing/v0/listingOffers");
        DefaultRequest<Object> signRequest = this.signRequest(String.valueOf(uri), HttpMethodName.POST, null);
        String payload = this.getString(batchOffersRequest);
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).POST(HttpRequest.BodyPublishers.ofString(payload)).build();
        JsonBodyHandler<GetListingOffersBatchResponse> handler = new JsonBodyHandler<GetListingOffersBatchResponse>(GetListingOffersBatchResponse.class);
        return this.getRequestWrapped(request, handler);
    }
}

