/*
 * Decompiled with CFR 0.152.
 */
package io.github.dft.amazon;

import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.dft.amazon.AmazonSellingPartnerSdk;
import io.github.dft.amazon.model.AmazonCredentials;
import io.github.dft.amazon.model.handler.JsonBodyHandler;
import io.github.dft.amazon.model.productfees.GetMyFeesEstimateResponse;
import io.github.dft.amazon.model.productfees.GetMyFeesEstimateResults;
import io.github.dft.amazon.model.productfees.GetMyFeesEstimatesRequest;
import io.github.dft.amazon.model.productfees.GetMyFeesEstimatesRequestBody;
import io.github.dft.amazon.model.productfees.GetMyFeesEstimatesResponse;
import io.github.dft.amazon.model.reports.v202106.ErrorList;
import java.net.URI;
import java.net.http.HttpRequest;

public class AmazonSPProductFees
extends AmazonSellingPartnerSdk {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public AmazonSPProductFees(AmazonCredentials amazonCredentials) {
        super(amazonCredentials);
    }

    public GetMyFeesEstimateResponse getMyFeesEstimateForSKU(String sku, GetMyFeesEstimatesRequest body) {
        String requestBody = this.getString(body);
        String finalPath = String.format("/products/fees/v0/listings/%s/feesEstimate", sku);
        DefaultRequest<Object> signRequest = this.signRequest(finalPath, HttpMethodName.POST, null, requestBody);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + finalPath)).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        JsonBodyHandler<GetMyFeesEstimateResponse> handler = new JsonBodyHandler<GetMyFeesEstimateResponse>(GetMyFeesEstimateResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetMyFeesEstimatesResponse getMyFeesEstimates(GetMyFeesEstimatesRequestBody body) {
        String requestBody = this.getString(body);
        DefaultRequest<Object> signRequest = this.signRequest("/products/fees/v0/feesEstimate", HttpMethodName.POST, null, requestBody);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/products/fees/v0/feesEstimate")).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        JsonBodyHandler<Object> handler = new JsonBodyHandler<Object>(Object.class);
        Object response = this.getRequestWrapped(request, handler);
        if (!response.getClass().getSimpleName().equalsIgnoreCase("ArrayList")) {
            GetMyFeesEstimateResults getMyFeesEstimateResults = new GetMyFeesEstimateResults();
            GetMyFeesEstimatesResponse getMyFeesEstimatesResponse = new GetMyFeesEstimatesResponse();
            getMyFeesEstimateResults.setErrors((ErrorList)this.objectMapper.convertValue(response, ErrorList.class));
            getMyFeesEstimatesResponse.add(getMyFeesEstimateResults);
            return getMyFeesEstimatesResponse;
        }
        return (GetMyFeesEstimatesResponse)this.objectMapper.convertValue(response, GetMyFeesEstimatesResponse.class);
    }

    public GetMyFeesEstimateResponse getMyFeesEstimateForASIN(String asin, GetMyFeesEstimatesRequest body) {
        this.refreshAccessToken();
        String requestBody = this.getString(body);
        String finalPath = String.format("/products/fees/v0/items/%s/feesEstimate", asin);
        DefaultRequest<Object> signRequest = this.signRequest(finalPath, HttpMethodName.POST, null, requestBody);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + finalPath)).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        JsonBodyHandler<GetMyFeesEstimateResponse> handler = new JsonBodyHandler<GetMyFeesEstimateResponse>(GetMyFeesEstimateResponse.class);
        return this.getRequestWrapped(request, handler);
    }
}

