/*
 * Decompiled with CFR 0.152.
 */
package io.github.dft.amazon;

import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import io.github.dft.amazon.AmazonSPTokens;
import io.github.dft.amazon.AmazonSellingPartnerSdk;
import io.github.dft.amazon.model.AmazonCredentials;
import io.github.dft.amazon.model.handler.JsonBodyHandler;
import io.github.dft.amazon.model.orders.v0.GetOrderAddressResponse;
import io.github.dft.amazon.model.orders.v0.GetOrderBuyerInfoResponse;
import io.github.dft.amazon.model.orders.v0.GetOrderItemsBuyerInfoResponse;
import io.github.dft.amazon.model.orders.v0.GetOrderItemsResponse;
import io.github.dft.amazon.model.orders.v0.GetOrderRegulatedInfoResponse;
import io.github.dft.amazon.model.orders.v0.GetOrderResponse;
import io.github.dft.amazon.model.orders.v0.GetOrdersResponse;
import io.github.dft.amazon.model.tokens.v202103.CreateRestrictedDataTokenRequest;
import io.github.dft.amazon.model.tokens.v202103.CreateRestrictedDataTokenResponse;
import io.github.dft.amazon.model.tokens.v202103.RestrictedResource;
import java.net.URI;
import java.net.http.HttpRequest;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class AmazonSPOrders
extends AmazonSellingPartnerSdk {
    private static final String AMAZON_ORDERS_PII_PATH = "/orders/v0/orders";
    private static final List<String> AMAZON_ORDERS_PII_DATA_ELEMENTS = Arrays.asList("buyerInfo", "shippingAddress");
    private String restrictedAccessToken;
    private ZonedDateTime restrictedAccessTokenExpireIn;
    private final AmazonSPTokens amazonSPTokens;

    public AmazonSPOrders(AmazonCredentials amazonCredentials) {
        super(amazonCredentials);
        this.amazonSPTokens = new AmazonSPTokens(amazonCredentials);
    }

    public GetOrdersResponse getOrders(HashMap<String, String> params, boolean isPII) {
        DefaultRequest<Object> signRequest = this.signRequest(AMAZON_ORDERS_PII_PATH, HttpMethodName.GET, params, null);
        String token = isPII ? this.getPIIAccessToken(this.createRestrictedDataToken(AMAZON_ORDERS_PII_PATH)) : this.amazonCredentials.getAccessToken();
        URIBuilder uriBuilder = new URIBuilder(this.sellingRegionEndpoint + AMAZON_ORDERS_PII_PATH);
        this.addParameters(uriBuilder, params);
        URI uri = uriBuilder.build();
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", token).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<GetOrdersResponse> handler = new JsonBodyHandler<GetOrdersResponse>(GetOrdersResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetOrdersResponse getOrders(HashMap<String, String> params) {
        return this.getOrders(params, false);
    }

    public CreateRestrictedDataTokenRequest createRestrictedDataToken(String restrictedTokenPath) {
        CreateRestrictedDataTokenRequest createRestrictedDataTokenRequest = new CreateRestrictedDataTokenRequest();
        ArrayList<RestrictedResource> restrictedResources = new ArrayList<RestrictedResource>();
        RestrictedResource restrictedResource = new RestrictedResource();
        restrictedResource.setMethod("GET");
        restrictedResource.setPath(restrictedTokenPath);
        restrictedResource.setDataElements(AMAZON_ORDERS_PII_DATA_ELEMENTS);
        restrictedResources.add(restrictedResource);
        createRestrictedDataTokenRequest.setRestrictedResources(restrictedResources);
        return createRestrictedDataTokenRequest;
    }

    private String getPIIAccessToken(CreateRestrictedDataTokenRequest createRestrictedDataTokenRequest) {
        if (this.restrictedAccessToken == null || ZonedDateTime.now(ZoneOffset.UTC).isAfter(this.restrictedAccessTokenExpireIn)) {
            CreateRestrictedDataTokenResponse createRestrictedDataTokenResponse = this.amazonSPTokens.createRestrictedDataToken(createRestrictedDataTokenRequest);
            this.restrictedAccessToken = createRestrictedDataTokenResponse.getRestrictedDataToken();
            this.restrictedAccessTokenExpireIn = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(createRestrictedDataTokenResponse.getExpiresIn().intValue());
        }
        return this.restrictedAccessToken;
    }

    public GetOrderResponse getOrder(String orderId) {
        return this.getOrder(orderId, false);
    }

    public GetOrderResponse getOrder(String orderId, boolean isPII) {
        orderId = StringUtils.isEmpty((CharSequence)orderId) ? "" : orderId;
        String token = isPII ? this.getPIIAccessToken(this.createRestrictedDataToken("/orders/v0/orders/" + orderId)) : this.amazonCredentials.getAccessToken();
        DefaultRequest<Object> signRequest = this.signRequest("/orders/v0/orders/{orderId}".replace("{orderId}", orderId), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/orders/v0/orders/" + orderId)).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", token).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<GetOrderResponse> handler = new JsonBodyHandler<GetOrderResponse>(GetOrderResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetOrderBuyerInfoResponse getOrderBuyerInfo(String orderId) {
        orderId = StringUtils.isEmpty((CharSequence)orderId) ? "" : orderId;
        DefaultRequest<Object> signRequest = this.signRequest("/orders/v0/orders/{orderId}/buyerInfo".replace("{orderId}", orderId), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/orders/v0/orders/{orderId}/buyerInfo".replace("{orderId}", orderId))).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<GetOrderBuyerInfoResponse> handler = new JsonBodyHandler<GetOrderBuyerInfoResponse>(GetOrderBuyerInfoResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetOrderAddressResponse getAddress(String orderId) {
        orderId = StringUtils.isEmpty((CharSequence)orderId) ? "" : orderId;
        DefaultRequest<Object> signRequest = this.signRequest("/orders/v0/orders/{orderId}/address".replace("{orderId}", orderId), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/orders/v0/orders/{orderId}/address".replace("{orderId}", orderId))).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<GetOrderAddressResponse> handler = new JsonBodyHandler<GetOrderAddressResponse>(GetOrderAddressResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetOrderItemsResponse getOrderItems(String orderId) {
        orderId = StringUtils.isEmpty((CharSequence)orderId) ? "" : orderId;
        DefaultRequest<Object> signRequest = this.signRequest("/orders/v0/orders/{orderId}/orderItems".replace("{orderId}", orderId), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/orders/v0/orders/{orderId}/orderItems".replace("{orderId}", orderId))).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<GetOrderItemsResponse> handler = new JsonBodyHandler<GetOrderItemsResponse>(GetOrderItemsResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetOrderItemsBuyerInfoResponse getOrderItemsBuyerInfo(String orderId) {
        orderId = StringUtils.isEmpty((CharSequence)orderId) ? "" : orderId;
        DefaultRequest<Object> signRequest = this.signRequest("/orders/v0/orders/{orderId}/orderItems/buyerInfo".replace("{orderId}", orderId), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/orders/v0/orders/{orderId}/orderItems/buyerInfo".replace("{orderId}", orderId))).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<GetOrderItemsBuyerInfoResponse> handler = new JsonBodyHandler<GetOrderItemsBuyerInfoResponse>(GetOrderItemsBuyerInfoResponse.class);
        return this.getRequestWrapped(request, handler);
    }

    public GetOrderRegulatedInfoResponse getOrderRegulatedInfo(String orderId) {
        orderId = StringUtils.isEmpty((CharSequence)orderId) ? "" : orderId;
        DefaultRequest<Object> signRequest = this.signRequest("/orders/v0/orders/{orderId}/regulatedInfo".replace("{orderId}", orderId), HttpMethodName.GET, null, null);
        HttpRequest request = HttpRequest.newBuilder(new URI(this.sellingRegionEndpoint + "/orders/v0/orders/{orderId}/regulatedInfo".replace("{orderId}", orderId))).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<GetOrderRegulatedInfoResponse> handler = new JsonBodyHandler<GetOrderRegulatedInfoResponse>(GetOrderRegulatedInfoResponse.class);
        return this.getRequestWrapped(request, handler);
    }
}

