/*
 * Decompiled with CFR 0.152.
 */
package io.github.dft.amazon;

import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import io.github.dft.amazon.AmazonSellingPartnerSdk;
import io.github.dft.amazon.model.AmazonCredentials;
import io.github.dft.amazon.model.catalogitems.v202204.CatalogCategoriesResponse;
import io.github.dft.amazon.model.catalogitems.v202204.Item;
import io.github.dft.amazon.model.catalogitems.v202204.ItemSearchResults;
import io.github.dft.amazon.model.handler.JsonBodyHandler;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.HashMap;
import org.apache.http.client.utils.URIBuilder;

public class AmazonSPCatalogItems
extends AmazonSellingPartnerSdk {
    public AmazonSPCatalogItems(AmazonCredentials amazonCredentials) {
        super(amazonCredentials);
    }

    public Item getCatalogItem(String asin, HashMap<String, String> params) {
        DefaultRequest<Object> signRequest = this.signRequest("/catalog/2022-04-01/items/" + asin, HttpMethodName.GET, params);
        URIBuilder uriBuilder = new URIBuilder(this.sellingRegionEndpoint + "/catalog/2022-04-01/items/" + asin);
        if (params != null && !params.isEmpty()) {
            for (String key : params.keySet()) {
                uriBuilder.addParameter(key, params.get(key));
            }
        }
        URI uri = uriBuilder.build();
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<Item> handler = new JsonBodyHandler<Item>(Item.class);
        return this.getRequestWrapped(request, handler);
    }

    public ItemSearchResults searchCatalogItems(HashMap<String, String> params) {
        DefaultRequest<Object> signRequest = this.signRequest("/catalog/2022-04-01/items/", HttpMethodName.GET, params);
        URIBuilder uriBuilder = new URIBuilder(this.sellingRegionEndpoint + "/catalog/2022-04-01/items/");
        if (params != null && !params.isEmpty()) {
            for (String key : params.keySet()) {
                uriBuilder.addParameter(key, params.get(key));
            }
        }
        URI uri = uriBuilder.build();
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<ItemSearchResults> handler = new JsonBodyHandler<ItemSearchResults>(ItemSearchResults.class);
        return this.getRequestWrapped(request, handler);
    }

    public CatalogCategoriesResponse listCatalogCategories(HashMap<String, String> params) {
        DefaultRequest<Object> signRequest = this.signRequest("/catalog/v0/categories", HttpMethodName.GET, params, null);
        URIBuilder uriBuilder = new URIBuilder(this.sellingRegionEndpoint + "/catalog/v0/categories");
        this.addParameters(uriBuilder, params);
        URI uri = uriBuilder.build();
        HttpRequest request = HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", "application/json").header("x-amz-access-token", this.amazonCredentials.getAccessToken()).header("Authorization", (String)signRequest.getHeaders().get("Authorization")).header("X-Amz-Security-Token", (String)signRequest.getHeaders().get("X-Amz-Security-Token")).header("X-Amz-Date", (String)signRequest.getHeaders().get("X-Amz-Date")).GET().build();
        JsonBodyHandler<CatalogCategoriesResponse> handler = new JsonBodyHandler<CatalogCategoriesResponse>(CatalogCategoriesResponse.class);
        return this.getRequestWrapped(request, handler);
    }
}

