package io.github.dft.amazon.constantcode;

import lombok.Data;

@Data
public class RateLimitConstants {

    public int CREATE_REPORT_API_CALL = 1;
    public int CREATE_REPORT_LIMIT_REFRESH = 60000;
    public int CREATE_REPORT_RATE_LIMIT = 1;

    public int GET_REPORT_API_CALL = 1;
    public int GET_REPORT_LIMIT_REFRESH = 1000;
    public int GET_REPORT_RATE_LIMIT = 2;

    public int GET_REPORT_DOCUMENT = 1;
    public int GET_REPORT_DOCUMENT_LIMIT_REFRESH = 60000;
    public int GET_REPORT_DOCUMENT_RATE_LIMIT = 1;

    public int GET_REPORTS_API_CALL = 1;
    public int GET_REPORTS_LIMIT_REFRESH = 30000;
    public int GET_REPORTS_RATE_LIMIT = 1;

    public int CANCEL_REPORT_API_CALL = 1;
    public int CANCEL_REPORT_LIMIT_REFRESH = 30000;
    public int CANCEL_REPORT_RATE_LIMIT = 1;

    public int CREATE_REPORT_SCHEDULE_API_CALL = 1;
    public int CREATE_REPORT_SCHEDULE_LIMIT_REFRESH = 30000;
    public int CREATE_REPORT_SCHEDULE_RATE_LIMIT = 1;

    public int GET_REPORT_SCHEDULES_API_CALL = 1;
    public int GET_REPORT_SCHEDULES_LIMIT_REFRESH = 30000;
    public int GET_REPORT_SCHEDULES_RATE_LIMIT = 1;

    public int GET_REPORT_SCHEDULE_API_CALL = 1;
    public int GET_REPORT_SCHEDULE_LIMIT_REFRESH = 30000;
    public int GET_REPORT_SCHEDULE_RATE_LIMIT = 1;

    public int CANCEL_REPORT_SCHEDULE_API_CALL = 1;
    public int CANCEL_REPORT_SCHEDULE_LIMIT_REFRESH = 30000;
    public int CANCEL_REPORT_SCHEDULE_RATE_LIMIT = 1;

    public int GET_MARKETPLACE_PARTICIPATION_API_CALL = 1;
    public int GET_MARKETPLACE_PARTICIPATION_LIMIT_REFRESH = 63000;
    public int GET_MARKETPLACE_PARTICIPATION_RATE_LIMIT = 1;

    public int GET_ORDERS_API_CALL = 1;
    public int GET_ORDERS_LIMIT_REFRESH = 60000;
    public int GET_ORDERS_RATE_LIMIT = 1;

    public int GET_ORDER_API_CALL = 1;
    public int GET_ORDER_LIMIT_REFRESH = 60000;
    public int GET_ORDER_RATE_LIMIT = 1;

    public int GET_ORDER_BUYER_INFO_API_CALL = 1;
    public int GET_ORDER_BUYER_INFO_LIMIT_REFRESH = 60000;
    public int GET_ORDER_BUYER_INFO_RATE_LIMIT = 1;

    public int GET_ORDER_ADDRESS_API_CALL = 1;
    public int GET_ORDER_ADDRESS_LIMIT_REFRESH = 60000;
    public int GET_ORDER_ADDRESS_RATE_LIMIT = 1;

    public int GET_ORDER_ITEMS_API_CALL = 1;
    public int GET_ORDER_ITEMS_LIMIT_REFRESH = 1000;
    public int GET_ORDER_ITEMS_RATE_LIMIT = 1;

    public int GET_ORDER_REGULATED_INFO_API_CALL = 1;
    public int GET_ORDER_REGULATED_INFO_LIMIT_REFRESH = 1000;
    public int GET_ORDER_REGULATED_INFO_RATE_LIMIT = 1;

    public int GET_ORDER_ITEMS_BUYER_INFO_API_CALL = 1;
    public int GET_ORDER_ITEMS_BUYER_INFO_LIMIT_REFRESH = 1000;
    public int GET_ORDER_ITEMS_BUYER_INFO_RATE_LIMIT = 1;

    public int CREATE_RESTRICTED_DATA_TOKEN_API_CALL = 1;
    public int CREATE_RESTRICTED_DATA_TOKEN_LIMIT_REFRESH = 1000;
    public int CREATE_RESTRICTED_DATA_TOKEN_RATE_LIMIT = 1;

    public int GET_MY_FEES_ESTIMATE_FOR_SKU_API_CALL = 1;
    public int GET_MY_FEES_ESTIMATE_FOR_SKU_LIMIT_REFRESH = 1000;
    public int GET_MY_FEES_ESTIMATE_FOR_SKU_RATE_LIMIT = 1;

    public int GET_MY_FEES_ESTIMATE_API_CALL = 1;
    public int GET_MY_FEES_ESTIMATE_LIMIT_REFRESH = 1000;
    public int GET_MY_FEES_ESTIMATE_RATE_LIMIT = 1;

    public int GET_MY_FEES_ESTIMATES_API_CALL = 1;
    public int GET_MY_FEES_ESTIMATES_LIMIT_REFRESH = 1000;
    public int GET_MY_FEES_ESTIMATES_RATE_LIMIT = 1;

    public int GET_CATALOG_ITEM_API_CALL = 2;
    public int GET_CATALOG_ITEM_LIMIT_REFRESH = 2000;
    public int GET_CATALOG_ITEM_RATE_LIMIT = 2;

    public int GET_SEARCH_CATALOG_ITEMS_API_CALL = 2;
    public int GET_SEARCH_CATALOG_ITEMS_LIMIT_REFRESH = 2000;
    public int GET_SEARCH_CATALOG_ITEMS_RATE_LIMIT = 2;
}