/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.metrics.prometheus;

import io.gitbub.devlibx.easy.helper.metrics.IMetrics;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetrics
implements IMetrics {
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetrics.class);
    private final Map<String, SummaryHolder> summaryMap = new HashMap<String, SummaryHolder>();
    private final Map<String, CounterHolder> counterMap = new HashMap<String, CounterHolder>();
    private final CollectorRegistry collectorRegistry = new CollectorRegistry();

    public <T> T getRegistry(Class<T> cls) {
        if (cls.isAssignableFrom(CollectorRegistry.class)) {
            return (T)this.collectorRegistry;
        }
        throw new IMetrics.InvalidRegistryTypeFoundException("PrometheusMetrics uses io.prometheus.client.CollectorRegistry as registry class");
    }

    public void inc(String name, String ... labels) {
        try {
            if (!this.counterMap.containsKey(name)) {
                this.registerCounter(name, name + " Help", new String[0]);
            }
            this.counterMap.get(name).inc(labels);
        }
        catch (RuntimeException e) {
            log.error("error in metrics inc method (runtime exception) - e={}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error("error in metrics inc method (exception) - e={}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public <T> T time(String name, Callable<T> callable, String ... labels) {
        try {
            if (!this.summaryMap.containsKey(name)) {
                this.registerTimer(name, name + " Help", new String[0]);
            }
            return (T)this.summaryMap.get(name).time(callable, labels);
        }
        catch (RuntimeException e) {
            log.error("error in timing method (runtime exception) - e={}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error("error in timing method (exception) - e={}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void observe(String name, double amt) {
        try {
            if (!this.summaryMap.containsKey(name)) {
                this.registerTimer(name, name + " Help", new String[0]);
            }
            this.summaryMap.get(name).observe(amt);
        }
        catch (RuntimeException e) {
            log.error("error in timing method (runtime exception) - e={}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error("error in timing method (exception) - e={}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void registerCounter(String name, String help, String ... labels) {
        try {
            Counter requests = labels != null && labels.length > 0 ? (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(name)).help(help)).labelNames(labels)).register() : (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name(name)).help(help)).register();
            this.collectorRegistry.register((Collector)requests);
            this.counterMap.put(name, new CounterHolder(name, requests, labels != null ? labels.length : 0));
        }
        catch (Exception e) {
            log.error("failed to register counter - name={}, error={}", (Object)name, (Object)e.getMessage());
        }
    }

    public void registerTimer(String name, String help, String ... labels) {
        try {
            Summary requests = labels != null && labels.length > 0 ? (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name(name)).help(help)).labelNames(labels)).quantile(0.5, 0.05).quantile(0.9, 0.01).quantile(0.99, 0.001).register() : (Summary)((Summary.Builder)((Summary.Builder)Summary.build().name(name)).help(help)).quantile(0.5, 0.05).quantile(0.9, 0.01).quantile(0.99, 0.001).register();
            this.collectorRegistry.register((Collector)requests);
            this.summaryMap.put(name, new SummaryHolder(name, requests, labels != null ? labels.length : 0));
        }
        catch (Exception e) {
            log.error("failed to register timer - name={}, error={}", (Object)name, (Object)e.getMessage());
        }
    }

    public CollectorRegistry getCollectorRegistry() {
        return this.collectorRegistry;
    }

    private static class SummaryHolder {
        private String name;
        private Summary summary;
        private int labelCount;

        public Object time(Callable callable, String ... labels) {
            if (this.labelCount == 0) {
                return this.summary.time(callable);
            }
            if (labels.length == this.labelCount) {
                return ((Summary.Child)this.summary.labels(labels)).time(callable);
            }
            Object[] temp = new String[this.labelCount];
            Arrays.fill(temp, "na");
            System.arraycopy(labels, 0, temp, 0, labels.length);
            return ((Summary.Child)this.summary.labels((String[])temp)).time(callable);
        }

        public void observe(double amt) {
            this.summary.observe(amt);
        }

        public String getName() {
            return this.name;
        }

        public Summary getSummary() {
            return this.summary;
        }

        public int getLabelCount() {
            return this.labelCount;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSummary(Summary summary) {
            this.summary = summary;
        }

        public void setLabelCount(int labelCount) {
            this.labelCount = labelCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SummaryHolder)) {
                return false;
            }
            SummaryHolder other = (SummaryHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLabelCount() != other.getLabelCount()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Summary this$summary = this.getSummary();
            Summary other$summary = other.getSummary();
            return !(this$summary == null ? other$summary != null : !this$summary.equals(other$summary));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SummaryHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLabelCount();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Summary $summary = this.getSummary();
            result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
            return result;
        }

        public String toString() {
            return "PrometheusMetrics.SummaryHolder(name=" + this.getName() + ", summary=" + this.getSummary() + ", labelCount=" + this.getLabelCount() + ")";
        }

        public SummaryHolder(String name, Summary summary, int labelCount) {
            this.name = name;
            this.summary = summary;
            this.labelCount = labelCount;
        }
    }

    private static class CounterHolder {
        private String name;
        private Counter counter;
        private int labelCount;

        public void inc(String ... labels) {
            if (this.labelCount == 0) {
                this.counter.inc();
            } else if (labels.length == this.labelCount) {
                ((Counter.Child)this.counter.labels(labels)).inc();
            } else {
                Object[] temp = new String[this.labelCount];
                Arrays.fill(temp, "na");
                System.arraycopy(labels, 0, temp, 0, labels.length);
                ((Counter.Child)this.counter.labels((String[])temp)).inc();
            }
        }

        public String getName() {
            return this.name;
        }

        public Counter getCounter() {
            return this.counter;
        }

        public int getLabelCount() {
            return this.labelCount;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCounter(Counter counter) {
            this.counter = counter;
        }

        public void setLabelCount(int labelCount) {
            this.labelCount = labelCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CounterHolder)) {
                return false;
            }
            CounterHolder other = (CounterHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLabelCount() != other.getLabelCount()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Counter this$counter = this.getCounter();
            Counter other$counter = other.getCounter();
            return !(this$counter == null ? other$counter != null : !this$counter.equals(other$counter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CounterHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLabelCount();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Counter $counter = this.getCounter();
            result = result * 59 + ($counter == null ? 43 : $counter.hashCode());
            return result;
        }

        public String toString() {
            return "PrometheusMetrics.CounterHolder(name=" + this.getName() + ", counter=" + this.getCounter() + ", labelCount=" + this.getLabelCount() + ")";
        }

        public CounterHolder(String name, Counter counter, int labelCount) {
            this.name = name;
            this.counter = counter;
            this.labelCount = labelCount;
        }
    }
}

