/*
 * Decompiled with CFR 0.152.
 */
package io.github.devatherock.json.formatter;

import io.github.devatherock.json.formatter.helpers.Constants;
import io.github.devatherock.json.formatter.helpers.CustomJsonConverter;
import io.github.devatherock.json.formatter.helpers.GsonJsonConverter;
import io.github.devatherock.json.formatter.helpers.JacksonJsonConverter;
import io.github.devatherock.json.formatter.helpers.JsonConverter;
import io.github.devatherock.json.formatter.helpers.SimpleJsonConverter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Instant;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JSONFormatter
extends Formatter {
    private static final JsonConverter CONVERTER = JSONFormatter.createJsonConverter();
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final Map<Integer, String> THREAD_NAME_CACHE = new LinkedHashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, String> eldest) {
            return this.size() > 10000;
        }
    };

    @Override
    public String format(LogRecord record) {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        object.put("@timestamp", Constants.ISO_8601_FORMAT.format(Instant.ofEpochMilli(record.getMillis())));
        object.put("logger_name", record.getLoggerName());
        object.put("level", record.getLevel().getName());
        object.put("thread_name", JSONFormatter.getThreadName(record.getThreadID()));
        if (null != record.getSourceClassName()) {
            object.put("class", record.getSourceClassName());
        }
        if (null != record.getSourceMethodName()) {
            object.put("method", record.getSourceMethodName());
        }
        object.put("message", this.formatMessage(record));
        if (null != record.getThrown()) {
            EnumMap<Constants.ExceptionKeys, String> exceptionInfo = new EnumMap<Constants.ExceptionKeys, String>(Constants.ExceptionKeys.class);
            exceptionInfo.put(Constants.ExceptionKeys.exception_class, record.getThrown().getClass().getName());
            if (record.getThrown().getMessage() != null) {
                exceptionInfo.put(Constants.ExceptionKeys.exception_message, record.getThrown().getMessage());
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            exceptionInfo.put(Constants.ExceptionKeys.stack_trace, sw.toString());
            object.put("exception", exceptionInfo);
        }
        return CONVERTER.convertToJson(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getThreadName(int logRecordThreadId) {
        String result = THREAD_NAME_CACHE.get(logRecordThreadId);
        if (result != null) {
            return result;
        }
        if (logRecordThreadId > 0x3FFFFFFF) {
            result = String.valueOf(logRecordThreadId);
        } else {
            ThreadInfo threadInfo = THREAD_MX_BEAN.getThreadInfo(logRecordThreadId);
            if (threadInfo == null) {
                return String.valueOf(logRecordThreadId);
            }
            result = threadInfo.getThreadName();
        }
        Map<Integer, String> map = THREAD_NAME_CACHE;
        synchronized (map) {
            THREAD_NAME_CACHE.put(logRecordThreadId, result);
        }
        return result;
    }

    private static JsonConverter createJsonConverter() {
        JsonConverter jsonConverter = null;
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            jsonConverter = new JacksonJsonConverter();
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.google.gson.Gson");
                jsonConverter = new GsonJsonConverter();
            }
            catch (ClassNotFoundException e1) {
                try {
                    Class.forName("org.json.simple.JSONObject");
                    jsonConverter = new SimpleJsonConverter();
                }
                catch (ClassNotFoundException e2) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "None of GSON/Jackson/json-simple found in classpath");
                    jsonConverter = new CustomJsonConverter();
                }
            }
        }
        return jsonConverter;
    }
}

