/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.mapping;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBPersistentEntityImpl;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBPersistentProperty;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBPersistentPropertyImpl;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;

public class DynamoDBMappingContext
extends AbstractMappingContext<DynamoDBPersistentEntityImpl<?>, DynamoDBPersistentProperty> {
    protected <T> DynamoDBPersistentEntityImpl<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new DynamoDBPersistentEntityImpl<T>(typeInformation, null);
    }

    protected DynamoDBPersistentProperty createPersistentProperty(Property property, DynamoDBPersistentEntityImpl<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new DynamoDBPersistentPropertyImpl(property, owner, simpleTypeHolder);
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        boolean hasHashKey = false;
        boolean hasRangeKey = false;
        for (Method method : type.getType().getMethods()) {
            if (method.isAnnotationPresent(DynamoDBHashKey.class)) {
                hasHashKey = true;
            }
            if (!method.isAnnotationPresent(DynamoDBRangeKey.class)) continue;
            hasRangeKey = true;
        }
        for (AccessibleObject accessibleObject : type.getType().getFields()) {
            if (accessibleObject.isAnnotationPresent(DynamoDBHashKey.class)) {
                hasHashKey = true;
            }
            if (!accessibleObject.isAnnotationPresent(DynamoDBRangeKey.class)) continue;
            hasRangeKey = true;
        }
        return type.getType().isAnnotationPresent(DynamoDBTable.class) || hasHashKey && hasRangeKey;
    }
}

