/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.testing;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import org.junit.Assert;

public class LogAssert {
    private static final String logFile = "logs/app.log";
    private static RandomAccessFile reader = null;

    private LogAssert() {
    }

    public static synchronized void assertNotContains(String ... events) throws IOException {
        try {
            LogAssert.assertContains(events);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    public static synchronized void assertContains(String ... events) throws IOException {
        String line;
        HashSet<String> expectedEvents = new HashSet<String>(events.length);
        for (String event : events) {
            expectedEvents.add(event);
        }
        HashSet<String> foundEvents = new HashSet<String>(events.length);
        if (reader == null) {
            reader = new RandomAccessFile(logFile, "r");
        }
        while ((line = reader.readLine()) != null) {
            line = new String(line.getBytes("ISO-8859-1"), "utf-8");
            for (String event : events) {
                if (!line.contains(event)) continue;
                foundEvents.add(event);
            }
        }
        expectedEvents.removeAll(foundEvents);
        if (!expectedEvents.isEmpty()) {
            Assert.fail((String)String.format("%d events not found: %s", expectedEvents.size(), ((Object)expectedEvents).toString()));
        }
    }
}

