/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import android.graphics.Bitmap;
import io.github.crow_misia.libyuv.Capacity;
import io.github.crow_misia.libyuv.Yuv;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a2\u0010\b\u001a\u00020\t*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0000\u001a!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0000\u00a2\u0006\u0002\u0010\u0014\u001a\u001c\u0010\u0015\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u001a%\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010*\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0000\u00a2\u0006\u0002\u0010\u0018\u001aS\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a*\u00020\u000226\u0010\u001b\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b( \u0012\u0004\u0012\u0002H\u001a0\u001cH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\""}, d2={"toBitmap", "Landroid/graphics/Bitmap;", "Ljava/nio/ByteBuffer;", "width", "", "height", "config", "Landroid/graphics/Bitmap$Config;", "copy", "", "dst", "", "dstOffset", "srcOffset", "length", "createByteBuffer", "", "capacities", "", "Lio/github/crow_misia/libyuv/Capacity;", "(Ljava/util/List;)[Ljava/nio/ByteBuffer;", "sliceRange", "offset", "sliceByLength", "(Ljava/nio/ByteBuffer;Ljava/util/List;)[Ljava/nio/ByteBuffer;", "execute", "T", "func", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "position", "limit", "(Ljava/nio/ByteBuffer;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "core_release"})
@SourceDebugExtension(value={"SMAP\nBufferExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferExt.kt\nio/github/crow_misia/libyuv/BufferExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n59#1,9:72\n59#1,5:81\n66#1,2:88\n1#2:71\n1863#3,2:86\n*S KotlinDebug\n*F\n+ 1 BufferExt.kt\nio/github/crow_misia/libyuv/BufferExtKt\n*L\n28#1:72,9\n39#1:81,5\n39#1:88,2\n44#1:86,2\n*E\n"})
public final class BufferExtKt {
    @NotNull
    public static final Bitmap toBitmap(@NotNull ByteBuffer $this$toBitmap, int width, int height, @NotNull Bitmap.Config config) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Bitmap bitmap2 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(...)");
        Bitmap it = bitmap = bitmap2;
        boolean bl = false;
        $this$toBitmap.position(0);
        it.copyPixelsFromBuffer((Buffer)$this$toBitmap);
        return bitmap;
    }

    public static final void copy(@NotNull ByteBuffer $this$copy, @NotNull byte[] dst, int dstOffset, int srcOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Object object = $this$copy.isDirect() ? $this$copy : (Object)$this$copy.array();
        Intrinsics.checkNotNull((Object)object);
        Object srcObj = object;
        if (!(dst.length >= length)) {
            boolean bl = false;
            String string = "dst size is less than length";
            throw new IllegalStateException(string.toString());
        }
        Yuv.INSTANCE.memcopy(dst, dstOffset, srcObj, srcOffset, length);
    }

    public static /* synthetic */ void copy$default(ByteBuffer byteBuffer, byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = byteBuffer.limit();
        }
        BufferExtKt.copy(byteBuffer, byArray, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ByteBuffer[] createByteBuffer(@NotNull List<Capacity> capacities) {
        int n;
        Intrinsics.checkNotNullParameter(capacities, (String)"capacities");
        if (!(!((Collection)capacities).isEmpty())) {
            throw new IllegalStateException("Check failed.");
        }
        Iterable iterable = capacities;
        Yuv yuv = Yuv.INSTANCE;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            int n3 = ((Capacity)t).unbox-impl();
            n = n2;
            boolean bl = false;
            void var10_9 = it;
            n2 = n + var10_9;
        }
        n = n2;
        ByteBuffer whole = yuv.allocNativeBuffer(n);
        return BufferExtKt.sliceByLength(whole, capacities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ByteBuffer sliceRange(@NotNull ByteBuffer $this$sliceRange, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$sliceRange, (String)"<this>");
        ByteBuffer $this$execute$iv = $this$sliceRange;
        boolean $i$f$execute = false;
        int previousPosition$iv = $this$execute$iv.position();
        int previousLimit$iv = $this$execute$iv.limit();
        try {
            boolean bl = false;
            $this$sliceRange.position(offset);
            $this$sliceRange.limit(offset + length);
            ByteBuffer byteBuffer = $this$sliceRange.slice();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slice(...)");
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        finally {
            $this$execute$iv.position(previousPosition$iv);
            $this$execute$iv.limit(previousLimit$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ByteBuffer[] sliceByLength(@NotNull ByteBuffer $this$sliceByLength, @NotNull List<Capacity> capacities) {
        Intrinsics.checkNotNullParameter((Object)$this$sliceByLength, (String)"<this>");
        Intrinsics.checkNotNullParameter(capacities, (String)"capacities");
        if (!(!((Collection)capacities).isEmpty())) {
            throw new IllegalStateException("Check failed.");
        }
        ByteBuffer $this$execute$iv = $this$sliceByLength;
        boolean $i$f$execute = false;
        int previousPosition$iv = $this$execute$iv.position();
        int previousLimit$iv = $this$execute$iv.limit();
        try {
            int limit = previousLimit$iv;
            boolean bl = false;
            int offset = 0;
            int index = 0;
            int num = capacities.size();
            Object[] results = new ByteBuffer[num + 1];
            Iterable $this$forEach$iv = capacities;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int sliceLength = ((Capacity)element$iv).unbox-impl();
                boolean bl2 = false;
                $this$sliceByLength.position(offset);
                $this$sliceByLength.limit(offset += sliceLength);
                int n = index;
                index = n + 1;
                results[n] = $this$sliceByLength.slice();
            }
            if (!(offset <= limit)) {
                boolean bl3 = false;
                String string = "buffer limit is bigger than expected";
                throw new IllegalStateException(string.toString());
            }
            results[index] = $this$sliceByLength;
            ByteBuffer[] byteBufferArray = (ByteBuffer[])ArraysKt.requireNoNulls((Object[])results);
            return byteBufferArray;
        }
        finally {
            $this$execute$iv.position(previousPosition$iv);
            $this$execute$iv.limit(previousLimit$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T execute(@NotNull ByteBuffer $this$execute, @NotNull Function2<? super Integer, ? super Integer, ? extends T> func) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        boolean $i$f$execute = false;
        int previousPosition = $this$execute.position();
        int previousLimit = $this$execute.limit();
        try {
            Object object = func.invoke((Object)previousPosition, (Object)previousLimit);
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$execute.position(previousPosition);
            $this$execute.limit(previousLimit);
            InlineMarker.finallyEnd((int)1);
        }
    }
}

