/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import android.graphics.Rect;
import io.github.crow_misia.libyuv.Buffer;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.Plane;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001d\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020$H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0003H\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R2\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007@PX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/github/crow_misia/libyuv/AbstractBuffer;", "Lio/github/crow_misia/libyuv/Buffer;", "buffer", "Ljava/nio/ByteBuffer;", "cropRect", "Landroid/graphics/Rect;", "planes", "", "Lio/github/crow_misia/libyuv/Plane;", "releaseCallback", "Ljava/lang/Runnable;", "(Ljava/nio/ByteBuffer;Landroid/graphics/Rect;[Lio/github/crow_misia/libyuv/Plane;Ljava/lang/Runnable;)V", "getBuffer$core_release", "()Ljava/nio/ByteBuffer;", "setBuffer$core_release", "(Ljava/nio/ByteBuffer;)V", "value", "getCropRect", "()Landroid/graphics/Rect;", "setCropRect", "(Landroid/graphics/Rect;)V", "<set-?>", "getPlanes", "()[Lio/github/crow_misia/libyuv/Plane;", "setPlanes$core_release", "([Lio/github/crow_misia/libyuv/Plane;)V", "[Lio/github/crow_misia/libyuv/Plane;", "Ljava/util/concurrent/atomic/AtomicReference;", "asBuffer", "asByteArray", "", "", "dst", "close", "", "write", "Ljava/io/OutputStream;", "core_release"})
@SourceDebugExtension(value={"SMAP\nAbstractBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractBuffer.kt\nio/github/crow_misia/libyuv/AbstractBuffer\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,86:1\n26#2:87\n1#3:88\n13309#4,2:89\n13309#4,2:91\n13309#4,2:93\n*S KotlinDebug\n*F\n+ 1 AbstractBuffer.kt\nio/github/crow_misia/libyuv/AbstractBuffer\n*L\n31#1:87\n54#1:89,2\n68#1:91,2\n78#1:93,2\n*E\n"})
public abstract class AbstractBuffer
implements Buffer {
    @Nullable
    private ByteBuffer buffer;
    @NotNull
    private Plane[] planes;
    @NotNull
    private Rect cropRect;
    @NotNull
    private final AtomicReference<Runnable> releaseCallback;

    public AbstractBuffer(@Nullable ByteBuffer buffer, @NotNull Rect cropRect, @NotNull Plane[] planes, @Nullable Runnable releaseCallback) {
        Intrinsics.checkNotNullParameter((Object)cropRect, (String)"cropRect");
        Intrinsics.checkNotNullParameter((Object)planes, (String)"planes");
        this.buffer = buffer;
        this.planes = planes;
        this.cropRect = cropRect;
        this.releaseCallback = new AtomicReference<Runnable>(releaseCallback);
    }

    @Nullable
    public final ByteBuffer getBuffer$core_release() {
        return this.buffer;
    }

    public final void setBuffer$core_release(@Nullable ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    @Override
    @NotNull
    public Plane[] getPlanes() {
        return this.planes;
    }

    public void setPlanes$core_release(@NotNull Plane[] planeArray) {
        Intrinsics.checkNotNullParameter((Object)planeArray, (String)"<set-?>");
        this.planes = planeArray;
    }

    @Override
    @NotNull
    public Rect getCropRect() {
        return this.cropRect;
    }

    public void setCropRect(@NotNull Rect value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Rect tmp = new Rect(value);
        if (!tmp.intersect(0, 0, this.getWidth(), this.getHeight())) {
            tmp.setEmpty();
        }
        this.cropRect = tmp;
    }

    @Override
    public void close() {
        this.buffer = null;
        Runnable runnable = this.releaseCallback.getAndSet(null);
        if (runnable != null) {
            runnable.run();
        }
        boolean $i$f$emptyArray = false;
        this.setPlanes$core_release(new Plane[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ByteBuffer asBuffer() {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = this.buffer;
        if (byteBuffer2 == null) {
            ByteBuffer byteBuffer3;
            AbstractBuffer $this$asBuffer_u24lambda_u243 = this;
            boolean bl = false;
            Plane[] planeArray = $this$asBuffer_u24lambda_u243.getPlanes();
            int n = 0;
            int n2 = planeArray.length;
            for (int i = 0; i < n2; ++i) {
                void it;
                Plane plane;
                Plane plane2 = plane = planeArray[i];
                int n3 = n;
                boolean bl2 = false;
                int n4 = it.getBuffer().limit();
                n = n3 + n4;
            }
            int size = n;
            ByteBuffer it = byteBuffer3 = ByteBuffer.allocateDirect(size);
            boolean bl3 = false;
            $this$asBuffer_u24lambda_u243.buffer = it;
            ByteBuffer buffer = byteBuffer3;
            Intrinsics.checkNotNull((Object)buffer);
            $this$asBuffer_u24lambda_u243.write(buffer);
            return buffer;
        }
        ByteBuffer it = byteBuffer = byteBuffer2;
        boolean bl = false;
        it.position(0);
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] asByteArray() {
        Plane[] planeArray = this.getPlanes();
        int n = 0;
        int n2 = planeArray.length;
        for (int i = 0; i < n2; ++i) {
            void it;
            Plane plane;
            Plane plane2 = plane = planeArray[i];
            int n3 = n;
            boolean bl = false;
            int n4 = it.getBuffer().limit();
            n = n3 + n4;
        }
        int size = n;
        byte[] buffer = new byte[size];
        this.asByteArray(buffer);
        return buffer;
    }

    @Override
    public int asByteArray(@NotNull byte[] dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int offset = 0;
        Plane[] $this$forEach$iv = this.getPlanes();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Plane element$iv;
            Plane plane = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ByteBuffer buffer = plane.getBuffer();
            int remain = dst.length - offset;
            int size = Math.min(buffer.limit(), remain);
            BufferExtKt.copy(buffer, dst, offset, 0, size);
            offset += size;
        }
        return offset;
    }

    @Override
    public int write(@NotNull OutputStream dst) {
        int n;
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Object[] objectArray = this.getPlanes();
        if (objectArray.length == 0) {
            throw new NoSuchElementException();
        }
        Plane it22 = objectArray[0];
        boolean $i$a$-maxOf-AbstractBuffer$write$tmpBufferSize$22 = false;
        int it22 = it22.getBuffer().limit();
        IntIterator $i$a$-maxOf-AbstractBuffer$write$tmpBufferSize$22 = new IntRange(1, ArraysKt.getLastIndex((Object[])objectArray)).iterator();
        while ($i$a$-maxOf-AbstractBuffer$write$tmpBufferSize$22.hasNext()) {
            int n2 = $i$a$-maxOf-AbstractBuffer$write$tmpBufferSize$22.nextInt();
            Object it = objectArray[n2];
            boolean bl = false;
            n = ((Plane)it).getBuffer().limit();
            if (it22 >= n) continue;
            it22 = n;
        }
        int tmpBufferSize = it22;
        byte[] tmpBuffer = new byte[tmpBufferSize];
        int ret = 0;
        Plane[] $this$forEach$iv = this.getPlanes();
        boolean $i$f$forEach = false;
        int n3 = $this$forEach$iv.length;
        for (n = 0; n < n3; ++n) {
            Plane element$iv;
            Plane it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            int size = it.getBuffer().limit();
            BufferExtKt.copy(it.getBuffer(), tmpBuffer, 0, 0, size);
            dst.write(tmpBuffer, 0, size);
            ret += size;
        }
        return ret;
    }

    @Override
    public void write(@NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Plane[] $this$forEach$iv = this.getPlanes();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ByteBuffer byteBuffer;
            Plane element$iv;
            Plane plane = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ByteBuffer it = byteBuffer = plane.getBuffer();
            boolean bl2 = false;
            it.position(0);
            dst.put(it);
        }
    }
}

