/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import android.graphics.Bitmap;
import android.graphics.Rect;
import io.github.crow_misia.libyuv.AbstractBuffer;
import io.github.crow_misia.libyuv.ArgbBuffer;
import io.github.crow_misia.libyuv.BitmapConverter;
import io.github.crow_misia.libyuv.Buffer32;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.BufferFactory;
import io.github.crow_misia.libyuv.BufferFirstAlpha;
import io.github.crow_misia.libyuv.FilterMode;
import io.github.crow_misia.libyuv.I420Buffer;
import io.github.crow_misia.libyuv.J400Buffer;
import io.github.crow_misia.libyuv.J420Buffer;
import io.github.crow_misia.libyuv.J422Buffer;
import io.github.crow_misia.libyuv.Nv12Buffer;
import io.github.crow_misia.libyuv.Nv21Buffer;
import io.github.crow_misia.libyuv.Plane;
import io.github.crow_misia.libyuv.PlanePrimitive;
import io.github.crow_misia.libyuv.RawBuffer;
import io.github.crow_misia.libyuv.Rgb24Buffer;
import io.github.crow_misia.libyuv.RotateMode;
import io.github.crow_misia.libyuv.Yuv;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\u00020\u0004:\u0001\"B3\b\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001aJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001cJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001dJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001eJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020 J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020!R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006#"}, d2={"Lio/github/crow_misia/libyuv/AbgrBuffer;", "Lio/github/crow_misia/libyuv/AbstractBuffer;", "Lio/github/crow_misia/libyuv/BitmapConverter;", "Lio/github/crow_misia/libyuv/Buffer32;", "Lio/github/crow_misia/libyuv/BufferFirstAlpha;", "buffer", "Ljava/nio/ByteBuffer;", "plane", "Lio/github/crow_misia/libyuv/Plane;", "width", "", "height", "releaseCallback", "Ljava/lang/Runnable;", "(Ljava/nio/ByteBuffer;Lio/github/crow_misia/libyuv/Plane;IILjava/lang/Runnable;)V", "getHeight", "()I", "getPlane", "()Lio/github/crow_misia/libyuv/Plane;", "getWidth", "asBitmap", "Landroid/graphics/Bitmap;", "convertTo", "", "dst", "Lio/github/crow_misia/libyuv/ArgbBuffer;", "Lio/github/crow_misia/libyuv/I420Buffer;", "Lio/github/crow_misia/libyuv/J400Buffer;", "Lio/github/crow_misia/libyuv/J420Buffer;", "Lio/github/crow_misia/libyuv/J422Buffer;", "Lio/github/crow_misia/libyuv/Nv12Buffer;", "Lio/github/crow_misia/libyuv/Nv21Buffer;", "Lio/github/crow_misia/libyuv/RawBuffer;", "Lio/github/crow_misia/libyuv/Rgb24Buffer;", "Factory", "core_release"})
public final class AbgrBuffer
extends AbstractBuffer
implements BitmapConverter,
Buffer32<AbgrBuffer>,
BufferFirstAlpha {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final Plane plane;
    private final int width;
    private final int height;

    private AbgrBuffer(ByteBuffer buffer, Plane plane, int width, int height, Runnable releaseCallback) {
        Plane[] planeArray = new Plane[]{plane};
        super(buffer, planeArray, releaseCallback);
        this.plane = plane;
        this.width = width;
        this.height = height;
    }

    @Override
    @NotNull
    public Plane getPlane() {
        return this.plane;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public Bitmap asBitmap() {
        return BufferExtKt.toBitmap(this.asBuffer(), this.getWidth(), this.getHeight(), Bitmap.Config.ARGB_8888);
    }

    @Override
    public final void convertTo(@NotNull I420Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertABGRToI420(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneU().getBuffer(), dst.getPlaneU().getRowStride(), dst.getPlaneV().getBuffer(), dst.getPlaneV().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull J400Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertABGRToJ400(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull J420Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertABGRToJ420(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneU().getBuffer(), dst.getPlaneU().getRowStride(), dst.getPlaneV().getBuffer(), dst.getPlaneV().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull J422Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertABGRToJ422(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneU().getBuffer(), dst.getPlaneU().getRowStride(), dst.getPlaneV().getBuffer(), dst.getPlaneV().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull Nv12Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertABGRToNV12(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneUV().getBuffer(), dst.getPlaneUV().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull Nv21Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertABGRToNV21(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneVU().getBuffer(), dst.getPlaneVU().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull ArgbBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertABGRToARGB(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull Rgb24Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertARGBToRAW(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull RawBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertARGBToRGB24(this.getPlane().getBuffer(), this.getPlane().getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public void convertTo(@NotNull AbgrBuffer dst) {
        Buffer32.DefaultImpls.convertTo(this, (Buffer32)dst);
    }

    @Override
    public void mirrorTo(@NotNull AbgrBuffer dst) {
        Buffer32.DefaultImpls.mirrorTo(this, (Buffer32)dst);
    }

    @Override
    public void rotate(@NotNull AbgrBuffer dst, @NotNull RotateMode rotateMode) {
        Buffer32.DefaultImpls.rotate(this, (Buffer32)dst, rotateMode);
    }

    @Override
    public void scale(@NotNull AbgrBuffer dst, @NotNull FilterMode filterMode) {
        Buffer32.DefaultImpls.scale(this, (Buffer32)dst, filterMode);
    }

    @Override
    public void scaleClip(@NotNull AbgrBuffer dst, @NotNull Rect rect, @NotNull FilterMode filterMode) {
        Buffer32.DefaultImpls.scaleClip(this, (Buffer32)dst, rect, filterMode);
    }

    @Override
    public void copyAlphaTo(@NotNull AbgrBuffer dst) {
        BufferFirstAlpha.DefaultImpls.copyAlphaTo((BufferFirstAlpha)this, dst);
    }

    @Override
    public void copyAlphaTo(@NotNull ArgbBuffer dst) {
        BufferFirstAlpha.DefaultImpls.copyAlphaTo((BufferFirstAlpha)this, dst);
    }

    public /* synthetic */ AbgrBuffer(ByteBuffer buffer, Plane plane, int width, int height, Runnable releaseCallback, DefaultConstructorMarker $constructor_marker) {
        this(buffer, plane, width, height, releaseCallback);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\nJ\u001e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J \u0010\u000b\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lio/github/crow_misia/libyuv/AbgrBuffer$Factory;", "Lio/github/crow_misia/libyuv/BufferFactory;", "Lio/github/crow_misia/libyuv/AbgrBuffer;", "()V", "allocate", "width", "", "height", "getStrideWithCapacity", "", "getStrideWithCapacity$core_release", "wrap", "plane", "Lio/github/crow_misia/libyuv/Plane;", "buffer", "Ljava/nio/ByteBuffer;", "core_release"})
    @SourceDebugExtension(value={"SMAP\nAbgrBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbgrBuffer.kt\nio/github/crow_misia/libyuv/AbgrBuffer$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
    public static final class Factory
    implements BufferFactory<AbgrBuffer> {
        private Factory() {
        }

        @NotNull
        public final int[] getStrideWithCapacity$core_release(int width, int height) {
            int stride = width << 2;
            int capacity = stride * height;
            int[] nArray = new int[]{stride, capacity};
            return nArray;
        }

        @Override
        @NotNull
        public AbgrBuffer allocate(int width, int height) {
            int[] nArray = this.getStrideWithCapacity$core_release(width, height);
            int stride = nArray[0];
            int capacity = nArray[1];
            ByteBuffer buffer = BufferExtKt.createByteBuffer(capacity);
            return new AbgrBuffer(buffer, new PlanePrimitive(stride, buffer), width, height, () -> Factory.allocate$lambda$0(buffer), null);
        }

        @Override
        @NotNull
        public AbgrBuffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (!buffer.isDirect()) {
                boolean $i$a$-check-AbgrBuffer$Factory$wrap$22 = false;
                String $i$a$-check-AbgrBuffer$Factory$wrap$22 = "Unsupported non-direct ByteBuffer.";
                throw new IllegalStateException($i$a$-check-AbgrBuffer$Factory$wrap$22.toString());
            }
            int[] nArray = this.getStrideWithCapacity$core_release(width, height);
            int stride = nArray[0];
            int capacity = nArray[1];
            ByteBuffer sliceBuffer = BufferExtKt.sliceRange(buffer, 0, capacity);
            return new AbgrBuffer(sliceBuffer, new PlanePrimitive(stride, sliceBuffer), width, height, null, null);
        }

        @NotNull
        public final AbgrBuffer wrap(@NotNull Plane plane, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
            return new AbgrBuffer(plane.getBuffer(), plane, width, height, null, null);
        }

        private static final void allocate$lambda$0(ByteBuffer $buffer) {
            Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
            Yuv.INSTANCE.freeNativeBuffer($buffer);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

